/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.application.ApplicationContextRequirement;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class XmlBasedApplicationContextRequirement
extends ApplicationContextRequirement.Support<XmlBasedApplicationContextRequirement> {
    @Nonnull
    private final List<Resource> _configurationFiles = new ArrayList<Resource>();

    @Nonnull
    public static XmlBasedApplicationContextRequirement applicationContextFor(Resource ... resources) {
        return XmlBasedApplicationContextRequirement.applicationContext().withConfigurations(resources);
    }

    @Nonnull
    public static XmlBasedApplicationContextRequirement applicationContextFor(File ... files) {
        return XmlBasedApplicationContextRequirement.applicationContext().withConfigurations(files);
    }

    @Nonnull
    public static XmlBasedApplicationContextRequirement applicationContextFor(URL ... files) {
        return XmlBasedApplicationContextRequirement.applicationContext().withConfigurations(files);
    }

    @Nonnull
    public static XmlBasedApplicationContextRequirement applicationContextFor(@Nonnull Class<?> relation, @Nonnull String file) {
        return XmlBasedApplicationContextRequirement.applicationContext().withConfiguration(relation, file);
    }

    @Nonnull
    public static XmlBasedApplicationContextRequirement applicationContextFor(@Nonnull ClassLoader classLoader, @Nonnull String file) {
        return XmlBasedApplicationContextRequirement.applicationContext().withConfiguration(classLoader, file);
    }

    @Nonnull
    private static XmlBasedApplicationContextRequirement applicationContext() {
        return new XmlBasedApplicationContextRequirement();
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfiguration(@Nonnull Resource resource) {
        return this.withConfigurations(resource);
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfigurations(Resource ... resources) {
        CollectionUtils.addAll(this._configurationFiles, (Object[])resources);
        return this;
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfigurations(File ... files) {
        for (File file : files) {
            this._configurationFiles.add((Resource)new FileSystemResource(file));
        }
        return this;
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfiguration(@Nonnull File file) {
        return this.withConfigurations(file);
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfigurations(URL ... files) {
        for (URL file : files) {
            this._configurationFiles.add((Resource)new UrlResource(file));
        }
        return this;
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfiguration(@Nonnull Class<?> relation, @Nonnull String file) {
        this._configurationFiles.add((Resource)new ClassPathResource(relation.getPackage().getName().replace('.', '/') + "/" + file, relation));
        return this;
    }

    @Nonnull
    public XmlBasedApplicationContextRequirement withConfiguration(@Nonnull ClassLoader classLoader, @Nonnull String file) {
        this._configurationFiles.add((Resource)new ClassPathResource(file, classLoader));
        return this;
    }

    @Nonnull
    public Collection<Resource> getConfigurationFiles() {
        return CollectionUtils.asImmutableList(this._configurationFiles);
    }

    @Override
    @Nonnull
    public XmlBasedApplicationContextRequirement withClassLoader(@Nonnull ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        return this;
    }
}

