/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.concurrent.BaseRetryingStrategy;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedCountStrategy;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedTimeStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.testing.BaseMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class Assert {
    public static final String ASSERT_CLASSNAME = Assert.class.getName();

    protected Assert() {
    }

    public static void assertThat(boolean actual) {
        Assert.assertThat(null, actual);
    }

    public static void assertThat(@Nullable String reason, boolean actual) {
        Assert.assertThat(reason, actual, BaseMatchers.is(true));
    }

    public static <T> void assertThat(@Nullable T actual, @Nonnull Matcher<T> matcher) {
        Assert.assertThat(null, actual, matcher);
    }

    public static <T> void assertThat(@Nullable String reason, @Nullable T actual, @Nonnull Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            if (reason != null) {
                description.appendText(reason);
            }
            description.appendText("\nExpected: ");
            description.appendDescriptionOf(matcher);
            description.appendText("\n     but: ");
            matcher.describeMismatch(actual, (Description)description);
            description.appendText("\n");
            Assert.fail(description.toString());
        }
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void fail(@Nullable String message) {
        AssertionError error = message != null ? new AssertionError((Object)message) : new AssertionError();
        ((Throwable)((Object)error)).setStackTrace(Assert.getCleanStackTrace());
        throw error;
    }

    @Nonnull
    protected static StackTraceElement[] getCleanStackTrace() {
        StackTraceElement element;
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>(Arrays.asList(Thread.currentThread().getStackTrace()));
        stackTrace.remove(0);
        Iterator i = stackTrace.iterator();
        while (i.hasNext() && Assert.shouldIgnoreClass(element = (StackTraceElement)i.next())) {
            i.remove();
        }
        return stackTrace.toArray(new StackTraceElement[stackTrace.size()]);
    }

    private static boolean shouldIgnoreClass(@Nonnull StackTraceElement element) {
        String clazz = element.getClassName();
        return clazz.equals(ASSERT_CLASSNAME) || clazz.startsWith(ASSERT_CLASSNAME + "$") || clazz.equals(Retryer.class.getName());
    }

    @Nonnull
    public static AssertWithRetryRespectingException assertWithRetries(@Nonnegative int maxNumbersOfRetries) {
        RetryForSpecifiedCountStrategy strategy = RetryForSpecifiedCountStrategy.retryForSpecifiedCountOf((int)maxNumbersOfRetries);
        return new AssertWithRetryRespectingException((BaseRetryingStrategy<Void, ?>)strategy);
    }

    @Nonnull
    public static AssertWithRetryRespectingException assertWithTimeout(@Nonnull String duration) {
        return Assert.assertWithTimeout(new Duration(duration));
    }

    @Nonnull
    public static AssertWithRetryRespectingException assertWithTimeout(@Nonnull Duration duration) {
        RetryForSpecifiedTimeStrategy strategy = RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)duration);
        return new AssertWithRetryRespectingException((BaseRetryingStrategy<Void, ?>)strategy);
    }

    @Nonnull
    public static AssertWithRetry assertWithRetry(@Nonnull RetryingStrategy<Void> retryingStrategy) {
        return new AssertWithRetry(retryingStrategy);
    }

    public static class AssertWithRetrySupport<S extends RetryingStrategy<Void>> {
        @Nonnull
        private final S _retryingStrategy;

        public AssertWithRetrySupport(@Nonnull S retryingStrategy) {
            this._retryingStrategy = retryingStrategy;
        }

        @Nonnull
        protected S getRetryingStrategy() {
            return this._retryingStrategy;
        }

        public <T> void that(@Nonnull Callable<T> fetchActual, @Nonnull Matcher<T> matcher) throws Exception {
            this.that(null, fetchActual, matcher);
        }

        public <T> void that(final @Nullable String reason, final @Nonnull Callable<T> fetchActual, final @Nonnull Matcher<T> matcher) throws Exception {
            Callable<Void> runnable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Assert.assertThat(reason, fetchActual.call(), matcher);
                    return null;
                }
            };
            Retryer.executeWithRetry((Callable)runnable, this._retryingStrategy, Exception.class);
        }
    }

    public static class AssertWithRetryRespectingException
    extends AssertWithRetrySupport<BaseRetryingStrategy<Void, ?>> {
        public AssertWithRetryRespectingException(@Nonnull BaseRetryingStrategy<Void, ?> retryingStrategy) {
            super(retryingStrategy);
            this.respecting(AssertionError.class);
        }

        @Nonnull
        public AssertWithRetryRespectingException respecting(Class<? extends Throwable> ... exceptionTypes) {
            ((BaseRetryingStrategy)this.getRetryingStrategy()).withExceptionsThatForceRetry((Class[])exceptionTypes);
            return this;
        }

        @Nonnull
        public AssertWithRetryRespectingException respecting(@Nonnull Iterable<Class<? extends Throwable>> exceptionTypes) {
            ((BaseRetryingStrategy)this.getRetryingStrategy()).withExceptionsThatForceRetry(exceptionTypes);
            return this;
        }
    }

    public static class AssertWithRetry
    extends AssertWithRetrySupport<RetryingStrategy<Void>> {
        public AssertWithRetry(@Nonnull RetryingStrategy<Void> retryingStrategy) {
            super(retryingStrategy);
        }
    }
}

