/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.testing.BaseMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class IterableMatchers {
    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> isEqualTo(T ... expectedItems) {
        return IterableMatchers.isEqualTo(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> isEqualTo(final @Nonnull Iterable<T> expectedItems) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public boolean matchesSafely(Iterable<T> items) {
                boolean result;
                if (items != null) {
                    result = true;
                    Iterator expectedItemsIterator = expectedItems.iterator();
                    Iterator itemsIterator = items.iterator();
                    while (expectedItemsIterator.hasNext() && itemsIterator.hasNext() && result) {
                        Object expectedItem = expectedItemsIterator.next();
                        Object item = itemsIterator.next();
                        result = expectedItem != null ? expectedItem.equals(item) : item == null;
                    }
                    if (result) {
                        result = !expectedItemsIterator.hasNext() && !itemsIterator.hasNext();
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is equal to ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAllItemsOf(T ... expectedItems) {
        return IterableMatchers.containsAllItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> containsAllItemsOf(@Nonnull Iterable<T> expectedItems) {
        final Collection expected = CollectionUtils.asCollection(expectedItems);
        return new TypeSafeMatcher<Iterable<T>>(){

            public boolean matchesSafely(Iterable<T> items) {
                boolean result;
                if (items != null) {
                    Collection actual = CollectionUtils.asCollection(items);
                    if (expected.size() == actual.size()) {
                        Iterator i = expected.iterator();
                        result = true;
                        while (i.hasNext() & result) {
                            Object expectedItem = i.next();
                            result = actual.contains(expectedItem);
                        }
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains all items ").appendValue((Object)expected);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterable<T>> containsItemsOf(T ... expectedItems) {
        return IterableMatchers.containsItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterable<T>> containsItemsOf(@Nonnull Iterable<T> expectedItems) {
        final Collection expected = CollectionUtils.asCollection(expectedItems);
        return new TypeSafeMatcher<Iterable<T>>(){

            public boolean matchesSafely(Iterable<T> items) {
                boolean result;
                if (items != null) {
                    Collection actual = CollectionUtils.asCollection(items);
                    Iterator i = expected.iterator();
                    result = true;
                    while (i.hasNext() & result) {
                        Object expectedItem = i.next();
                        result = actual.contains(expectedItem);
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains items ").appendValue((Object)expected);
            }
        };
    }

    @Nonnull
    public static Matcher<Collection<?>> hasSize(@Nonnegative int size) {
        return BaseMatchers.hasSize(size);
    }

    @Nonnull
    public static Matcher<Collection<?>> hasSameSizeAs(@Nullable Object what) {
        return BaseMatchers.hasSameSizeAs(what);
    }

    protected IterableMatchers() {
    }
}

