/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.concurrent.Callable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedTimeStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.util.Duration;

public class TestingUtils {
    @Nullable
    public static void waitFor(@Nonnull Runnable what, @Nonnull String maxWaitTime) throws AssertionError {
        TestingUtils.waitFor(what, new Duration(maxWaitTime));
    }

    @Nullable
    public static void waitFor(@Nonnull Runnable what, @Nonnegative long maxWaitTime) throws AssertionError {
        TestingUtils.waitFor(what, new Duration(maxWaitTime));
    }

    @Nullable
    public static void waitFor(@Nonnull Runnable what, @Nonnull Duration maxWaitTime) throws AssertionError {
        Retryer.executeWithRetry((Runnable)what, (RetryingStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)maxWaitTime).withExceptionsThatForceRetry(new Class[]{AssertionError.class}));
    }

    @Nullable
    public static <T> T waitFor(@Nonnull Callable<T> what, @Nonnull String maxWaitTime) throws AssertionError {
        return TestingUtils.waitFor(what, new Duration(maxWaitTime));
    }

    @Nullable
    public static <T> T waitFor(@Nonnull Callable<T> what, @Nonnegative long maxWaitTime) throws AssertionError {
        return TestingUtils.waitFor(what, new Duration(maxWaitTime));
    }

    @Nullable
    public static <T> T waitFor(@Nonnull Callable<T> what, @Nonnull Duration maxWaitTime) throws AssertionError {
        return (T)Retryer.executeWithRetry(what, (RetryingStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)maxWaitTime).withExceptionsThatForceRetry(new Class[]{AssertionError.class}));
    }

    private TestingUtils() {
    }
}

