/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.environments;

import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.reflection.ClassUtils;

public abstract class BaseEnvironment
implements Closeable {
    protected BaseEnvironment() {
    }

    @Nullable
    protected String findFileFor(@Nonnull Class<?> aClass, @Nonnull String fileNameSuffixOfClasses, @Nonnull String fileNameInPackage) {
        String configurationOfClass;
        ClassLoader classLoader = aClass.getClassLoader();
        String configuration = classLoader.getResource(configurationOfClass = this.getFileNameOfClass(aClass, fileNameSuffixOfClasses)) != null ? configurationOfClass : this.findFileFor(aClass.getPackage(), classLoader, fileNameInPackage);
        return configuration;
    }

    @Nonnull
    protected String getFileNameOfClass(@Nonnull Class<?> aClass, String configurationFileNameSuffixOfClasses) {
        return aClass.getName().replace('.', '/') + configurationFileNameSuffixOfClasses;
    }

    @Nullable
    protected String findFileFor(@Nonnull Package aPackage, @Nonnull ClassLoader classLoader, @Nonnull String fileNameInPackage) {
        String configuration = null;
        String current = aPackage.getName();
        while (configuration == null && current != null) {
            String configurationOfPackage = this.getFileNameOfPackage(current, fileNameInPackage);
            if (classLoader.getResource(configurationOfPackage) != null) {
                configuration = configurationOfPackage;
                continue;
            }
            current = this.getParentPackageName(current);
        }
        return configuration;
    }

    @Nonnull
    protected String getFileNameOfPackage(@Nonnull String packageName, @Nonnull String fileNameInPackage) {
        return packageName.replace('.', '/') + "/" + fileNameInPackage;
    }

    @Nullable
    protected String getParentPackageName(@Nonnull String packageName) {
        int lastDot = packageName.lastIndexOf(46);
        String parentPackageName = lastDot > 0 ? packageName.substring(0, lastDot) : null;
        return parentPackageName;
    }

    @Nonnull
    protected Class<?> findTopFromCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Class found = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            Class currentClass = ClassUtils.findClass((String)stackTraceElement.getClassName());
            if (currentClass == Thread.class || currentClass.isAssignableFrom(this.getClass())) continue;
            found = currentClass;
            break;
        }
        return found != null ? found : this.getClass();
    }
}

