/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.codec.HashFunction;

public class HashFunctionUtils {
    public static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Nonnull
    public static <T extends HashFunction> Constructor<? extends T> selectConstructorFor(@Nonnull Class<T> requiredType, @Nonnull Class<? extends T> defaultImplementation) {
        String typePropertyName = requiredType.getName() + ".implementation";
        Class<? extends T> type = HashFunctionUtils.retrieveDefaultType(typePropertyName, requiredType, defaultImplementation);
        Constructor<? extends T> constructor = HashFunctionUtils.retrieveDefaultConstructorFor(typePropertyName, type);
        return constructor;
    }

    @Nonnull
    public static <T extends HashFunction> T newInstanceOf(@Nonnull Constructor<? extends T> constructor) {
        try {
            return (T)((HashFunction)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof InvocationTargetException ? e.getCause() : null;
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Could not create an instance of '" + constructor + "'.", e);
        }
    }

    @Nonnull
    private static <T extends HashFunction> Class<? extends T> retrieveDefaultType(@Nonnull String propertyName, @Nonnull Class<T> hashFunctionType, @Nonnull Class<? extends T> defaultImplementatio) {
        Class<?> plainType;
        String typeName = System.getProperty(propertyName, defaultImplementatio.getName());
        try {
            plainType = HashFunctionUtils.class.getClassLoader().loadClass(typeName.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Illegal value of '" + propertyName + "'. Could not find class for name: " + typeName, e);
        }
        if (!hashFunctionType.isAssignableFrom(plainType)) {
            throw new IllegalArgumentException("Illegal value of '" + propertyName + "'. Class '" + typeName + "' is not type of '" + hashFunctionType.getName() + "'.");
        }
        return plainType;
    }

    @Nonnull
    private static <T extends HashFunction> Constructor<? extends T> retrieveDefaultConstructorFor(@Nonnull String propertyName, @Nonnull Class<? extends T> hashFunctionType) {
        Constructor<T> constructor;
        try {
            constructor = hashFunctionType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal value of '" + propertyName + "'. Class '" + hashFunctionType.getName() + "' has no default constructor.", e);
        }
        constructor.setAccessible(true);
        return constructor;
    }

    @Nonnull
    private static char[] asHexCharacters(@Nonnull byte[] bytes) {
        int length = bytes.length;
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            out[j++] = HEX_CHARACTERS[(0xF0 & b) >>> 4];
            out[j++] = HEX_CHARACTERS[0xF & b];
        }
        return out;
    }

    @Nonnull
    public static String asHexString(@Nonnull byte[] bytes) {
        return new String(HashFunctionUtils.asHexCharacters(bytes));
    }

    private HashFunctionUtils() {
    }
}

