/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.codec.DefaultSha1;
import org.echocat.jomon.runtime.codec.HashFunctionUtils;
import org.echocat.jomon.runtime.codec.Sha1;

public class Sha1Utils {
    protected static final Constructor<? extends Sha1> DEFAULT_CONSTRUCTOR = HashFunctionUtils.selectConstructorFor(Sha1.class, DefaultSha1.class);

    @Nonnull
    public static Sha1 sha1() {
        return HashFunctionUtils.newInstanceOf(DEFAULT_CONSTRUCTOR);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable String with) {
        return Sha1Utils.sha1().update(with);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable String with, @Nonnull Charset charset) {
        return Sha1Utils.sha1().update(with, charset);
    }

    @Nonnull
    public static Sha1 sha1Of(byte with) {
        return Sha1Utils.sha1().update(with);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable byte[] with) {
        return Sha1Utils.sha1().update(with);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable byte[] with, @Nonnegative int offset, @Nonnegative int length) {
        return Sha1Utils.sha1().update(with, offset, length);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable @WillNotClose InputStream is) throws IOException {
        return Sha1Utils.sha1().update(is);
    }

    @Nonnull
    public static Sha1 sha1Of(@Nullable File file) throws IOException {
        return Sha1Utils.sha1().update(file);
    }

    private Sha1Utils() {
    }
}

