/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.codec.DefaultSha256;
import org.echocat.jomon.runtime.codec.HashFunctionUtils;
import org.echocat.jomon.runtime.codec.Sha256;

public class Sha256Utils {
    protected static final Constructor<? extends Sha256> DEFAULT_CONSTRUCTOR = HashFunctionUtils.selectConstructorFor(Sha256.class, DefaultSha256.class);

    @Nonnull
    public static Sha256 sha256() {
        return HashFunctionUtils.newInstanceOf(DEFAULT_CONSTRUCTOR);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable String with) {
        return Sha256Utils.sha256().update(with);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable String with, @Nonnull Charset charset) {
        return Sha256Utils.sha256().update(with, charset);
    }

    @Nonnull
    public static Sha256 sha256Of(byte with) {
        return Sha256Utils.sha256().update(with);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable byte[] with) {
        return Sha256Utils.sha256().update(with);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable byte[] with, @Nonnegative int offset, @Nonnegative int length) {
        return Sha256Utils.sha256().update(with, offset, length);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable @WillNotClose InputStream is) throws IOException {
        return Sha256Utils.sha256().update(is);
    }

    @Nonnull
    public static Sha256 sha256Of(@Nullable File file) throws IOException {
        return Sha256Utils.sha256().update(file);
    }

    private Sha256Utils() {
    }
}

