/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.codec.DefaultSha384;
import org.echocat.jomon.runtime.codec.HashFunctionUtils;
import org.echocat.jomon.runtime.codec.Sha384;

public class Sha384Utils {
    protected static final Constructor<? extends Sha384> DEFAULT_CONSTRUCTOR = HashFunctionUtils.selectConstructorFor(Sha384.class, DefaultSha384.class);

    @Nonnull
    public static Sha384 sha384() {
        return HashFunctionUtils.newInstanceOf(DEFAULT_CONSTRUCTOR);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable String with) {
        return Sha384Utils.sha384().update(with);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable String with, @Nonnull Charset charset) {
        return Sha384Utils.sha384().update(with, charset);
    }

    @Nonnull
    public static Sha384 sha384Of(byte with) {
        return Sha384Utils.sha384().update(with);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable byte[] with) {
        return Sha384Utils.sha384().update(with);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable byte[] with, @Nonnegative int offset, @Nonnegative int length) {
        return Sha384Utils.sha384().update(with, offset, length);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable @WillNotClose InputStream is) throws IOException {
        return Sha384Utils.sha384().update(is);
    }

    @Nonnull
    public static Sha384 sha384Of(@Nullable File file) throws IOException {
        return Sha384Utils.sha384().update(file);
    }

    private Sha384Utils() {
    }
}

