/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.concurrent.RetryingStatus;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.DurationRangeRequirement;
import org.echocat.jomon.runtime.util.DurationRequirement;
import org.echocat.jomon.runtime.util.ExactDurationRequirement;

public abstract class BaseRetryingStrategy<T, S extends BaseRetryingStrategy<T, S>>
implements RetryingStrategy<T> {
    private Set<Class<? extends Throwable>> _exceptionsThatForceRetry = Collections.emptySet();
    private Set<T> _resultsThatForceRetry = Collections.emptySet();
    private DurationRequirement _waitBetweenEachTry;

    protected BaseRetryingStrategy(@Nonnull DurationRequirement defaultWaitBetweenEachTry) {
        this._waitBetweenEachTry = defaultWaitBetweenEachTry;
    }

    @Nonnull
    public S withExceptionsThatForceRetry(Class<? extends Throwable> ... exceptionTypes) {
        return this.withExceptionsThatForceRetry(Arrays.asList(exceptionTypes));
    }

    @Nonnull
    public S withExceptionsThatForceRetry(@Nonnull Iterable<Class<? extends Throwable>> exceptionTypes) {
        this._exceptionsThatForceRetry = CollectionUtils.asImmutableSet(exceptionTypes);
        return this.thisInstance();
    }

    @Nonnull
    public S withResultsThatForceRetry(T ... results) {
        return this.withResultsThatForceRetry((Iterable<T>)Arrays.asList(results));
    }

    @Nonnull
    public S withResultsThatForceRetry(@Nonnull Iterable<T> results) {
        this._resultsThatForceRetry = CollectionUtils.asImmutableSet(results);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull DurationRequirement requirement) {
        this._waitBetweenEachTry = requirement;
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnegative long duration) {
        this._waitBetweenEachTry = new ExactDurationRequirement(duration);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull String duration) {
        this._waitBetweenEachTry = new ExactDurationRequirement(duration);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull Duration duration) {
        this._waitBetweenEachTry = new ExactDurationRequirement(duration);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull @Including String from, @Nonnull @Excluding String to) {
        this._waitBetweenEachTry = new DurationRangeRequirement(from, to);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull @Including Long from, @Nonnull @Excluding Long to) {
        this._waitBetweenEachTry = new DurationRangeRequirement(from, to);
        return this.thisInstance();
    }

    @Nonnull
    public S withWaitBetweenEachTry(@Nonnull @Including Duration from, @Nonnull @Excluding Duration to) {
        this._waitBetweenEachTry = new DurationRangeRequirement(from, to);
        return this.thisInstance();
    }

    protected boolean isExceptionThatForceRetry(@Nonnull Throwable e) {
        boolean result = false;
        for (Class<? extends Throwable> exceptionType : this._exceptionsThatForceRetry) {
            if (!exceptionType.isInstance(e)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isResultThatForceRetry(@Nullable T result) {
        return this._resultsThatForceRetry.contains(result);
    }

    @Nonnull
    public Set<Class<? extends Throwable>> getExceptionsThatForceRetry() {
        return this._exceptionsThatForceRetry;
    }

    @Nonnull
    public Set<T> getResultsThatForceRetry() {
        return this._resultsThatForceRetry;
    }

    @Nonnull
    public DurationRequirement getWaitBetweenEachTry() {
        return this._waitBetweenEachTry;
    }

    public RetryingStrategy<T> asUnmodifiable() {
        return new Unmodifiable();
    }

    @Nonnull
    protected S thisInstance() {
        return (S)this;
    }

    protected class Unmodifiable
    implements RetryingStrategy<T> {
        protected Unmodifiable() {
        }

        @Override
        public void beforeTry(@Nonnull RetryingStatus status) {
            BaseRetryingStrategy.this.beforeTry(status);
        }

        @Override
        public boolean isRetryRequiredForResult(@Nonnull T result, @Nonnull RetryingStatus status) {
            return BaseRetryingStrategy.this.isRetryRequiredForResult(result, status);
        }

        @Override
        public boolean isRetryRequiredForException(@Nonnull Throwable e, @Nonnull RetryingStatus status) {
            return BaseRetryingStrategy.this.isRetryRequiredForException(e, status);
        }
    }
}

