/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.concurrent.BaseRetryingStrategy;
import org.echocat.jomon.runtime.concurrent.RetryingStatus;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.DurationGenerator;
import org.echocat.jomon.runtime.util.IncreasingDurationRequirement;

@ThreadSafe
public class RetryForSpecifiedTimeStrategy<T>
extends BaseRetryingStrategy<T, RetryForSpecifiedTimeStrategy<T>> {
    private final Duration _maximumWaitTime;

    @Nonnull
    public static <T> RetryForSpecifiedTimeStrategy<T> retryForSpecifiedTimeOf(@Nonnull String maximumWaitTime) {
        return new RetryForSpecifiedTimeStrategy<T>(maximumWaitTime);
    }

    @Nonnull
    public static <T> RetryForSpecifiedTimeStrategy<T> retryForSpecifiedTimeOf(@Nonnegative long maximumWaitTime) {
        return new RetryForSpecifiedTimeStrategy<T>(maximumWaitTime);
    }

    @Nonnull
    public static <T> RetryForSpecifiedTimeStrategy<T> retryForSpecifiedTimeOf(@Nonnull Duration maximumWaitTime) {
        return new RetryForSpecifiedTimeStrategy<T>(maximumWaitTime);
    }

    public RetryForSpecifiedTimeStrategy(@Nonnull String maximumWaitTime) {
        this(new Duration(maximumWaitTime));
    }

    public RetryForSpecifiedTimeStrategy(@Nonnegative long maximumWaitTime) {
        this(new Duration(maximumWaitTime));
    }

    public RetryForSpecifiedTimeStrategy(@Nonnull Duration maximumWaitTime) {
        super(new IncreasingDurationRequirement("10ms"));
        this._maximumWaitTime = maximumWaitTime;
    }

    @Override
    public boolean isRetryRequiredForException(@Nonnull Throwable e, @Nonnull RetryingStatus status) {
        return this.isExceptionThatForceRetry(e) && this._maximumWaitTime.isGreaterThan(status.getDurationSinceStart());
    }

    @Override
    public boolean isRetryRequiredForResult(@Nullable T result, @Nonnull RetryingStatus status) {
        return this.isResultThatForceRetry(result) && this._maximumWaitTime.isGreaterThan(status.getDurationSinceStart());
    }

    @Override
    public void beforeTry(@Nonnull RetryingStatus status) {
        Duration durationSinceStart;
        if (status.getCurrentTry() > 1L && this._maximumWaitTime.isGreaterThan(durationSinceStart = status.getDurationSinceStart())) {
            try {
                Duration targetDuration = DurationGenerator.generateDuration(this.getWaitBetweenEachTry());
                Duration leftDuration = this._maximumWaitTime.minus(durationSinceStart);
                if (targetDuration.isLessThanOrEqualTo(leftDuration)) {
                    targetDuration.sleep();
                } else {
                    leftDuration.sleep();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nonnull
    public Duration getMaximumWaitTime() {
        return this._maximumWaitTime;
    }
}

