/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.format;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.format.MessageFormatter;

public class DefaultMessageFormatter
implements MessageFormatter {
    private static final Pattern PARAMETER_REPLACE_PATTERN = Pattern.compile("\\{([a-zA-Z0-9]+)([,}])");
    private final Map<String, Integer> _parameterKeyToIndex;
    private final MessageFormat _messageFormat;

    @Nonnull
    public static DefaultMessageFormatter messageFormatterFor(@Nonnull String pattern, @Nonnull Locale locale, String ... keys) {
        return new DefaultMessageFormatter(pattern, locale, keys);
    }

    @Nonnull
    public static DefaultMessageFormatter messageFormatterFor(@Nonnull String pattern, String ... keys) {
        return DefaultMessageFormatter.messageFormatterFor(pattern, Locale.US, keys);
    }

    public DefaultMessageFormatter(@Nonnull String pattern, String ... keys) {
        this(pattern, Locale.US, keys);
    }

    public DefaultMessageFormatter(@Nonnull String pattern, @Nonnull Locale locale, String ... keys) {
        this._parameterKeyToIndex = this.toParameterKeyToIndex(keys);
        this._messageFormat = this.toMessageFormat(pattern, locale, this._parameterKeyToIndex);
    }

    @Override
    @Nonnull
    public String format(@Nonnull Map<String, Object> parameters) {
        Object[] values = this.toParameterValues(parameters, this._parameterKeyToIndex);
        return this._messageFormat.format(values);
    }

    @Nonnull
    protected MessageFormat toMessageFormat(@Nonnull String pattern, @Nonnull Locale locale, @Nonnull Map<String, Integer> parameterKeyToIndex) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = PARAMETER_REPLACE_PATTERN.matcher(pattern);
        while (matcher.find()) {
            String key = matcher.group(1);
            Integer index = parameterKeyToIndex.get(key);
            if (index == null) continue;
            matcher.appendReplacement(sb, "{" + index + "$2");
        }
        matcher.appendTail(sb);
        return new MessageFormat(sb.toString(), locale);
    }

    @Nonnull
    protected Object[] toParameterValues(@Nonnull Map<String, Object> parameters, @Nonnull Map<String, Integer> parameterKeyToIndex) {
        Object[] result = new Object[parameterKeyToIndex.size() + 1];
        for (Map.Entry<String, Integer> parameterKeyAndIndex : parameterKeyToIndex.entrySet()) {
            result[parameterKeyAndIndex.getValue().intValue()] = parameters.get(parameterKeyAndIndex.getKey());
        }
        result[result.length - 1] = null;
        return result;
    }

    @Nonnull
    protected Map<String, Integer> toParameterKeyToIndex(String ... keys) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (keys != null) {
            int i = 0;
            for (String key : keys) {
                result.put(key, i++);
            }
        }
        return Collections.unmodifiableMap(result);
    }
}

