/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.id;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.id.IdProvider;
import org.echocat.jomon.runtime.jaxb.XmlId;

public class AnnotationBasedIdProvider<ID, B>
implements IdProvider<ID, B> {
    private static final List<Class<? extends Annotation>> ANNOTATION_TYPES = Arrays.asList(XmlId.class);
    private final Map<Class<?>, Method> _typeToGetIdMethod;

    public AnnotationBasedIdProvider(Class<?> ... types) {
        this(types != null ? Arrays.asList(types) : null);
    }

    public AnnotationBasedIdProvider(@Nullable Iterable<Class<?>> types) {
        this._typeToGetIdMethod = types != null ? this.getTypeToGetIdMethodForInternal(types) : Collections.emptyMap();
    }

    @Nonnull
    protected Map<Class<?>, Method> getTypeToGetIdMethodForInternal(@Nonnull Iterable<Class<?>> types) {
        HashMap typeToGetIdMethod = new HashMap();
        for (Class<?> type : types) {
            typeToGetIdMethod.put(type, this.getGetIdMethodForInternal(type));
        }
        return Collections.unmodifiableMap(typeToGetIdMethod);
    }

    @Nonnull
    protected Method getGetIdMethodForInternal(@Nonnull Class<?> type) {
        BeanInfo beanInfo = this.getBeanInfoFor(type);
        Method getIdMethod = null;
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || !this.hasIdAnnotation(type, descriptor)) continue;
            if (getIdMethod != null) {
                throw new IllegalArgumentException(type.getName() + " has multiple id annotations.");
            }
            getIdMethod = readMethod;
        }
        if (getIdMethod == null) {
            throw new IllegalArgumentException(type.getName() + " has no id annotations.");
        }
        return getIdMethod;
    }

    @Nonnull
    protected BeanInfo getBeanInfoFor(@Nonnull Class<?> type) {
        try {
            return Introspector.getBeanInfo(type, Object.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not read beanInfo of " + type.getName() + ".", e);
        }
    }

    protected boolean hasIdAnnotation(@Nonnull Class<?> type, @Nonnull PropertyDescriptor descriptor) {
        boolean writeMethodHasIdAnnotation;
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        boolean readMethodHasIdAnnotation = readMethod != null && this.hasIdAnnotation(readMethod);
        boolean bl = writeMethodHasIdAnnotation = writeMethod != null && this.hasIdAnnotation(writeMethod);
        if (readMethodHasIdAnnotation && writeMethodHasIdAnnotation) {
            throw new IllegalArgumentException("Property " + type.getName() + "." + descriptor.getName() + " has multiple id annotations.");
        }
        return readMethodHasIdAnnotation || writeMethodHasIdAnnotation;
    }

    protected boolean hasIdAnnotation(@Nonnull Method method) {
        boolean result = false;
        for (Class<Annotation> annotationType : this.getIdAnnotationTypes()) {
            if (method.getAnnotation(annotationType) == null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nonnull
    protected Iterable<Class<? extends Annotation>> getIdAnnotationTypes() {
        return ANNOTATION_TYPES;
    }

    @Override
    public ID provideIdOf(@Nonnull B bean) {
        Method getIdMethod = this.getGetIdMethodFor(bean);
        try {
            return (ID)getIdMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access " + getIdMethod + ".", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException("Could not invoke " + getIdMethod + ".", cause != null ? cause : e);
        }
    }

    @Nonnull
    protected Method getGetIdMethodFor(@Nonnull B bean) {
        return this.getGetIdMethodFor(bean.getClass());
    }

    @Nonnull
    protected Method getGetIdMethodFor(@Nonnull Class<?> type) {
        Method method = this._typeToGetIdMethod.get(type);
        if (method == null) {
            for (Map.Entry<Class<?>, Method> typeAndMethod : this._typeToGetIdMethod.entrySet()) {
                if (!typeAndMethod.getKey().isAssignableFrom(type)) continue;
                method = typeAndMethod.getValue();
                break;
            }
            if (method == null) {
                throw new IllegalArgumentException("Unknown type: " + type.getName());
            }
        }
        return method;
    }
}

