/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.ByteUtils;
import org.echocat.jomon.runtime.io.ChunkAwareSerializer;
import org.echocat.jomon.runtime.io.SerializableBy;
import org.echocat.jomon.runtime.io.Serializer;

public class Serializers {
    @Nonnull
    private static final ChunkAwareSerializer<Boolean> BOOLEAN_SERIALIZER = new BooleanSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Byte> BYTE_SERIALIZER = new ByteSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Short> SHORT_SERIALIZER = new ShortSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Integer> INTEGER_SERIALIZER = new IntegerSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Long> LONG_SERIALIZER = new LongSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Float> FLOAT_SERIALIZER = new FloatSerializer();
    @Nonnull
    private static final ChunkAwareSerializer<Double> DOUBLE_SERIALIZER = new DoubleSerializer();
    @Nonnull
    private static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    @Nonnull
    private static final Map<Class<?>, Serializer<?>> TYPE_TO_SERIALIZER_CACHE = new WeakHashMap();
    @Nonnull
    private static final Map<Class<?>, ChunkAwareSerializer<?>> TYPE_TO_CHUNK_AWARE_SERIALIZER = CollectionUtils.asMap(Boolean.class, BOOLEAN_SERIALIZER, Boolean.TYPE, BOOLEAN_SERIALIZER, Byte.class, BYTE_SERIALIZER, Byte.TYPE, BYTE_SERIALIZER, Short.class, SHORT_SERIALIZER, Short.TYPE, SHORT_SERIALIZER, Integer.class, INTEGER_SERIALIZER, Integer.TYPE, INTEGER_SERIALIZER, Long.class, LONG_SERIALIZER, Long.TYPE, LONG_SERIALIZER, Float.class, FLOAT_SERIALIZER, Float.TYPE, FLOAT_SERIALIZER, Double.class, DOUBLE_SERIALIZER, Double.TYPE, DOUBLE_SERIALIZER);
    @Nonnull
    private static final Map<Class<?>, Serializer<?>> TYPE_TO_SERIALIZER = CollectionUtils.asMap(Boolean.class, BOOLEAN_SERIALIZER, Boolean.TYPE, BOOLEAN_SERIALIZER, Byte.class, BYTE_SERIALIZER, Byte.TYPE, BYTE_SERIALIZER, Short.class, SHORT_SERIALIZER, Short.TYPE, SHORT_SERIALIZER, Integer.class, INTEGER_SERIALIZER, Integer.TYPE, INTEGER_SERIALIZER, Long.class, LONG_SERIALIZER, Long.TYPE, LONG_SERIALIZER, Float.class, FLOAT_SERIALIZER, Float.TYPE, FLOAT_SERIALIZER, Double.class, DOUBLE_SERIALIZER, Double.TYPE, DOUBLE_SERIALIZER, String.class, STRING_SERIALIZER);

    @Nonnull
    public static ChunkAwareSerializer<Boolean> booleanSerializer() {
        return BOOLEAN_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Byte> byteSerializer() {
        return BYTE_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Short> shortSerializer() {
        return SHORT_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Integer> integerSerializer() {
        return INTEGER_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Long> longSerializer() {
        return LONG_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Float> floatSerializer() {
        return FLOAT_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<Double> doubleSerializer() {
        return DOUBLE_SERIALIZER;
    }

    @Nonnull
    public static Serializer<String> stringSerializer() {
        return STRING_SERIALIZER;
    }

    @Nonnull
    public static ChunkAwareSerializer<String> stringSerializer(@Nonnegative int bufferSize, @Nonnull Charset charset) {
        return new ChunkAwareStringSerializer(bufferSize, charset);
    }

    @Nonnull
    public static ChunkAwareSerializer<String> stringSerializer(@Nonnegative int bufferSize) {
        return Serializers.stringSerializer(bufferSize, Charset.defaultCharset());
    }

    @Nonnegative
    public static int getChunkSizeOf(@Nonnull Class<?> type) throws IllegalArgumentException {
        ChunkAwareSerializer<?> serializer = Serializers.getChunkAwareSerializerOf(type);
        return serializer.getChunkSize();
    }

    @Nullable
    @Nonnegative
    public static Integer findChunkSizeOf(@Nonnull Class<?> type) {
        ChunkAwareSerializer<?> serializer = Serializers.findChunkAwareSerializerOf(type);
        return serializer != null ? Integer.valueOf(serializer.getChunkSize()) : null;
    }

    @Nonnull
    public static <T> ChunkAwareSerializer<T> getChunkAwareSerializerOf(@Nonnull Class<T> type) throws IllegalArgumentException {
        ChunkAwareSerializer<T> result = Serializers.findChunkAwareSerializerOf(type);
        if (result == null) {
            throw new IllegalArgumentException("There is no serializer available for " + type.getName() + ".");
        }
        return result;
    }

    @Nonnull
    public static <T> Serializer<T> getSerializerOf(@Nonnull Class<T> type) throws IllegalArgumentException {
        Serializer<T> result = Serializers.findSerializerOf(type);
        if (result == null) {
            throw new IllegalArgumentException("There is no serializer available for " + type.getName() + ".");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> Serializer<T> findSerializerOf(@Nonnull Class<T> type) {
        Serializer<Object> result = TYPE_TO_SERIALIZER.get(type);
        if (result == null) {
            Map<Class<?>, Serializer<?>> map = TYPE_TO_SERIALIZER_CACHE;
            synchronized (map) {
                result = TYPE_TO_SERIALIZER_CACHE.get(type);
                if (result == null) {
                    Class<Serializer<T>> serializerType = Serializers.findSerializerTypeOf(type);
                    if (serializerType != null) {
                        try {
                            result = serializerType.newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not create an instance of " + serializerType.getName() + " to serialize " + type.getName() + ".", e);
                        }
                        TYPE_TO_SERIALIZER_CACHE.put(type, result);
                    } else {
                        result = null;
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    public static <T> ChunkAwareSerializer<T> findChunkAwareSerializerOf(@Nonnull Class<T> type) {
        ChunkAwareSerializer result = TYPE_TO_CHUNK_AWARE_SERIALIZER.get(type);
        if (result == null) {
            Serializer<T> serializer = Serializers.findSerializerOf(type);
            result = serializer instanceof ChunkAwareSerializer ? (ChunkAwareSerializer)serializer : null;
        }
        return result;
    }

    @Nullable
    public static <T> Class<Serializer<T>> findSerializerTypeOf(@Nonnull Class<T> type) {
        SerializableBy annotation = type.getAnnotation(SerializableBy.class);
        return annotation != null ? annotation.value() : null;
    }

    private Serializers() {
    }

    @ThreadSafe
    @Immutable
    public static class StringSerializer
    implements Serializer<String> {
        @Override
        @Nullable
        public String read(@Nonnull DataInput from) throws IOException {
            return from.readUTF();
        }

        @Override
        public void write(@Nullable String value, @Nonnull DataOutput to) throws IOException {
            to.writeUTF(value);
        }
    }

    @ThreadSafe
    @Immutable
    public static class ChunkAwareStringSerializer
    implements ChunkAwareSerializer<String> {
        @Nonnull
        private final Charset _charset;
        @Nonnegative
        private final int _bufferSize;
        @Nonnegative
        private final int _chunkSize;

        public ChunkAwareStringSerializer(@Nonnegative int bufferSize, @Nonnull Charset charset) {
            this._bufferSize = bufferSize;
            this._charset = charset;
            this._chunkSize = ByteUtils.getStringChunkSizeFor(bufferSize);
        }

        @Override
        public int getChunkSize() {
            return this._chunkSize;
        }

        @Override
        @Nullable
        public String read(@Nonnull DataInput from) throws IOException {
            byte[] buffer = new byte[this._chunkSize];
            from.readFully(buffer);
            return ByteUtils.getString(buffer, this._bufferSize, 0, this._charset);
        }

        @Override
        public void write(@Nullable String value, @Nonnull DataOutput to) throws IOException {
            byte[] buffer = new byte[this._chunkSize];
            ByteUtils.putString(buffer, this._bufferSize, 0, value, this._charset);
            to.write(buffer);
        }
    }

    @ThreadSafe
    @Immutable
    public static class DoubleSerializer
    implements ChunkAwareSerializer<Double> {
        @Override
        public int getChunkSize() {
            return 8;
        }

        @Override
        @Nonnull
        public Double read(@Nonnull DataInput from) throws IOException {
            return from.readDouble();
        }

        @Override
        public void write(@Nonnull Double value, @Nonnull DataOutput to) throws IOException {
            to.writeDouble(value);
        }
    }

    @ThreadSafe
    @Immutable
    public static class FloatSerializer
    implements ChunkAwareSerializer<Float> {
        @Override
        public int getChunkSize() {
            return 4;
        }

        @Override
        @Nonnull
        public Float read(@Nonnull DataInput from) throws IOException {
            return Float.valueOf(from.readFloat());
        }

        @Override
        public void write(@Nonnull Float value, @Nonnull DataOutput to) throws IOException {
            to.writeFloat(value.floatValue());
        }
    }

    @ThreadSafe
    @Immutable
    public static class LongSerializer
    implements ChunkAwareSerializer<Long> {
        @Override
        public int getChunkSize() {
            return 8;
        }

        @Override
        @Nonnull
        public Long read(@Nonnull DataInput from) throws IOException {
            return from.readLong();
        }

        @Override
        public void write(@Nonnull Long value, @Nonnull DataOutput to) throws IOException {
            to.writeLong(value);
        }
    }

    @ThreadSafe
    @Immutable
    public static class IntegerSerializer
    implements ChunkAwareSerializer<Integer> {
        @Override
        public int getChunkSize() {
            return 4;
        }

        @Override
        @Nonnull
        public Integer read(@Nonnull DataInput from) throws IOException {
            return from.readInt();
        }

        @Override
        public void write(@Nonnull Integer value, @Nonnull DataOutput to) throws IOException {
            to.writeInt(value);
        }
    }

    @ThreadSafe
    @Immutable
    public static class ShortSerializer
    implements ChunkAwareSerializer<Short> {
        @Override
        public int getChunkSize() {
            return 2;
        }

        @Override
        @Nonnull
        public Short read(@Nonnull DataInput from) throws IOException {
            return from.readShort();
        }

        @Override
        public void write(@Nonnull Short value, @Nonnull DataOutput to) throws IOException {
            to.writeShort(value.shortValue());
        }
    }

    @ThreadSafe
    @Immutable
    public static class ByteSerializer
    implements ChunkAwareSerializer<Byte> {
        @Override
        public int getChunkSize() {
            return 1;
        }

        @Override
        @Nonnull
        public Byte read(@Nonnull DataInput from) throws IOException {
            return from.readByte();
        }

        @Override
        public void write(@Nonnull Byte value, @Nonnull DataOutput to) throws IOException {
            to.writeByte(value.byteValue());
        }
    }

    @ThreadSafe
    @Immutable
    public static class BooleanSerializer
    implements ChunkAwareSerializer<Boolean> {
        @Override
        public int getChunkSize() {
            return 1;
        }

        @Override
        @Nonnull
        public Boolean read(@Nonnull DataInput from) throws IOException {
            return from.readBoolean();
        }

        @Override
        public void write(@Nonnull Boolean value, @Nonnull DataOutput to) throws IOException {
            to.writeBoolean(value);
        }
    }
}

