/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.io.ByteUtils;
import org.echocat.jomon.runtime.io.ChunkAwareSerializer;
import org.echocat.jomon.runtime.io.Serializers;
import org.echocat.jomon.runtime.util.ByteCount;

public class StreamUtils {
    private StreamUtils() {
    }

    @Nonnegative
    public static <T> int writeObject(@Nonnull Class<T> type, @Nullable T value, @Nonnull DataOutput to) throws IOException {
        ChunkAwareSerializer<T> serializer = Serializers.getChunkAwareSerializerOf(type);
        serializer.write(value, to);
        return serializer.getChunkSize();
    }

    @Nonnegative
    public static <T> int writeObject(@Nonnull Class<T> type, @Nullable T value, @Nonnull OutputStream to) throws IOException {
        return StreamUtils.writeObject(type, value, StreamUtils.toDataOutput(to));
    }

    public static void writeBoolean(boolean value, @Nonnull DataOutput to) throws IOException {
        to.writeBoolean(value);
    }

    public static void writeBoolean(boolean value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeBoolean(value, StreamUtils.toDataOutput(to));
    }

    public static void writeByte(byte value, @Nonnull DataOutput to) throws IOException {
        to.writeByte(value);
    }

    public static void writeByte(byte value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeByte(value, StreamUtils.toDataOutput(to));
    }

    public static void writeShort(short value, @Nonnull DataOutput to) throws IOException {
        to.writeShort(value);
    }

    public static void writeShort(short value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeShort(value, StreamUtils.toDataOutput(to));
    }

    public static void writeInteger(int value, @Nonnull DataOutput to) throws IOException {
        to.writeInt(value);
    }

    public static void writeInteger(int value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeInteger(value, StreamUtils.toDataOutput(to));
    }

    public static void writeLong(long value, @Nonnull DataOutput to) throws IOException {
        to.writeLong(value);
    }

    public static void writeLong(long value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeLong(value, StreamUtils.toDataOutput(to));
    }

    public static void writeFloat(float value, @Nonnull DataOutput to) throws IOException {
        to.writeFloat(value);
    }

    public static void writeFloat(float value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeFloat(value, StreamUtils.toDataOutput(to));
    }

    public static void writeDouble(double value, @Nonnull DataOutput to) throws IOException {
        to.writeDouble(value);
    }

    public static void writeDouble(double value, @Nonnull OutputStream to) throws IOException {
        StreamUtils.writeDouble(value, StreamUtils.toDataOutput(to));
    }

    @Nonnegative
    public static int writeString(@Nonnegative int bufferSize, @Nullable String value, @Nonnull Charset charset, @Nonnull DataOutput to) throws IOException {
        ChunkAwareSerializer<String> serializer = Serializers.stringSerializer(bufferSize, charset);
        serializer.write(value, to);
        return serializer.getChunkSize();
    }

    @Nonnegative
    public static int writeString(@Nonnegative int bufferSize, @Nullable String value, @Nonnull Charset charset, @Nonnull OutputStream to) throws IOException {
        return StreamUtils.writeString(bufferSize, value, charset, StreamUtils.toDataOutput(to));
    }

    @Nonnegative
    public static int writeZeros(@Nonnegative int numberOfZeros, @Nonnull DataOutput to) throws IOException {
        int totalWritten;
        int numberOfBytesWriteNow;
        byte[] buffer = ByteUtils.DEFAULT_BUFFER_SIZE.allocate();
        for (totalWritten = 0; totalWritten < numberOfZeros; totalWritten += numberOfBytesWriteNow) {
            numberOfBytesWriteNow = totalWritten + buffer.length <= numberOfZeros ? buffer.length : numberOfZeros - totalWritten;
            to.write(buffer, 0, numberOfBytesWriteNow);
        }
        if (totalWritten != numberOfZeros) {
            throw new IllegalStateException("Write to much from stream? Write " + ByteCount.byteCountOf(totalWritten) + " but expected was " + ByteCount.byteCountOf(numberOfZeros) + ".");
        }
        return numberOfZeros;
    }

    @Nonnegative
    public static int writeZeros(@Nonnegative int numberOfZeros, @Nonnull OutputStream to) throws IOException {
        return StreamUtils.writeZeros(numberOfZeros, StreamUtils.toDataOutput(to));
    }

    public static boolean readBoolean(@Nonnull DataInput from) throws IOException {
        return from.readBoolean();
    }

    public static boolean readBoolean(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readBoolean(StreamUtils.toDataInput(from));
    }

    public static byte readByte(@Nonnull DataInput from) throws IOException {
        return from.readByte();
    }

    public static byte readByte(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readByte(StreamUtils.toDataInput(from));
    }

    public static short readShort(@Nonnull DataInput from) throws IOException {
        return from.readShort();
    }

    public static short readShort(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readShort(StreamUtils.toDataInput(from));
    }

    public static int readInteger(@Nonnull DataInput from) throws IOException {
        return from.readInt();
    }

    public static int readInteger(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readInteger(StreamUtils.toDataInput(from));
    }

    public static long readLong(@Nonnull DataInput from) throws IOException {
        return from.readLong();
    }

    public static long readLong(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readLong(StreamUtils.toDataInput(from));
    }

    public static float readFloat(@Nonnull DataInput from) throws IOException {
        return from.readFloat();
    }

    public static float readFloat(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readFloat(StreamUtils.toDataInput(from));
    }

    public static double readDouble(@Nonnull DataInput from) throws IOException {
        return from.readDouble();
    }

    public static double readDouble(@Nonnull InputStream from) throws IOException {
        return StreamUtils.readDouble(StreamUtils.toDataInput(from));
    }

    @Nullable
    public static String readString(@Nonnull DataInput from, @Nonnegative int bufferSize, @Nonnull Charset charset) throws IOException {
        return (String)Serializers.stringSerializer(bufferSize, charset).read(from);
    }

    public static void readZeros(@Nonnull DataInput from, @Nonnegative int numberOfZeros) throws IOException {
        int totalRead;
        int read;
        byte[] buffer = ByteUtils.DEFAULT_BUFFER_SIZE.allocate();
        for (totalRead = 0; totalRead < numberOfZeros; totalRead += read) {
            read = totalRead + buffer.length <= numberOfZeros ? buffer.length : numberOfZeros - totalRead;
            from.readFully(buffer, 0, read);
            for (int i = 0; i < read; ++i) {
                if (buffer[i] == -128) continue;
                throw new IOException("Found an non zero byte at a position where one is expected.");
            }
        }
        if (totalRead != numberOfZeros) {
            throw new IllegalStateException("Read to much from stream? Read " + ByteCount.byteCountOf(totalRead) + " but expected was " + ByteCount.byteCountOf(numberOfZeros) + ".");
        }
    }

    public static void readZeros(@Nonnull InputStream from, @Nonnegative int numberOfZeros) throws IOException {
        StreamUtils.readZeros(StreamUtils.toDataInput(from), numberOfZeros);
    }

    @Nullable
    public static <T> T readObject(@Nonnull Class<T> type, @Nonnull DataInput from) throws IOException {
        ChunkAwareSerializer<T> serializer = Serializers.getChunkAwareSerializerOf(type);
        return serializer.read(from);
    }

    @Nullable
    public static <T> T readObject(@Nonnull Class<T> type, @Nonnull InputStream from) throws IOException {
        return StreamUtils.readObject(type, StreamUtils.toDataInput(from));
    }

    @Nonnull
    public static byte[] read(@Nonnull DataInput from, @Nonnegative int numberOfBytes) throws IOException {
        byte[] buffer = new byte[numberOfBytes];
        from.readFully(buffer, 0, numberOfBytes);
        return buffer;
    }

    public static void readFixedByteCount(@Nonnull InputStream from, @Nonnull byte[] to, @Nonnegative int offsetInTo, @Nonnegative int length) throws IOException {
        int read;
        for (int totalRead = 0; totalRead < length; totalRead += read) {
            read = from.read(to, offsetInTo + totalRead, length - totalRead);
            if (read > -1) continue;
            throw new EOFException("Stream ended unexpected. Read " + ByteCount.byteCountOf(totalRead + read) + " but expected was " + ByteCount.byteCountOf(length) + ".");
        }
    }

    @Nonnull
    public static DataOutput toDataOutput(@Nonnull OutputStream outputStream) {
        return new DataOutputStream(outputStream);
    }

    @Nonnull
    public static DataInput toDataInput(@Nonnull InputStream inputStream) {
        return new DataInputStream(inputStream);
    }
}

