/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainedIterator<I, O>
implements CloseableIterator<O> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainedIterator.class);
    private final Iterator<I> _inputs;
    private Iterator<O> _current;

    public ChainedIterator(@Nonnull Iterator<I> inputs) {
        this._inputs = inputs;
    }

    public ChainedIterator(@Nonnull Iterable<I> inputs) {
        this(inputs.iterator());
    }

    @SafeVarargs
    public ChainedIterator(I ... inputs) {
        this((Iterable<I>)Arrays.asList(inputs));
    }

    @Override
    public boolean hasNext() {
        while ((this._current == null || !this._current.hasNext()) && this._inputs.hasNext()) {
            this.beforeNext();
            I nextInput = this._inputs.next();
            this._current = this.nextIterator(nextInput);
        }
        return this._current != null && this._current.hasNext();
    }

    @Override
    public O next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._current.next();
    }

    @Nullable
    protected abstract Iterator<O> nextIterator(@Nullable I var1);

    protected void beforeNext() {
        Iterator<O> current = this.getCurrent();
        if (current instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)current)).close();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not close the other iterator '" + this.getCurrent() + "' before redirecting to the next iterator.", e);
            }
        }
    }

    @Override
    public void remove() {
        if (this._current != null) {
            this._current.remove();
        }
    }

    @Nullable
    protected Iterator<O> getCurrent() {
        return this._current;
    }

    @Override
    public void close() {
        Iterator<O> current = this.getCurrent();
        if (current instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)current)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.warn("Could not clean close the iterator '" + this + "'. " + " But now this object will be cleaned by the garbage collector.", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }
}

