/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.repository.Limited;

public class LimitedIterator<T>
implements CloseableIterator<T> {
    private final Iterator<T> _inputIterator;
    private final Long _maximumEntriesToReturn;
    private Long _entriesReturned;

    public LimitedIterator(@Nullable Iterator<T> inputIterator, @Nullable Limited limited) {
        this._inputIterator = inputIterator != null ? inputIterator : CollectionUtils.emptyIterator();
        this._maximumEntriesToReturn = limited != null ? limited.getMaximumOfEntriesToReturn() : null;
        this._entriesReturned = 0L;
    }

    @Override
    public boolean hasNext() {
        return this._inputIterator.hasNext() && (this._maximumEntriesToReturn == null || this._entriesReturned < this._maximumEntriesToReturn);
    }

    @Override
    public T next() {
        if (this._maximumEntriesToReturn == null || this._entriesReturned < this._maximumEntriesToReturn) {
            Long l = this._entriesReturned;
            Long l2 = this._entriesReturned = Long.valueOf(this._entriesReturned + 1L);
            return this._inputIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this._inputIterator.remove();
    }

    @Override
    public void close() {
        if (this._inputIterator instanceof CloseableIterator) {
            ((CloseableIterator)this._inputIterator).close();
        }
    }
}

