/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.iterators;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.iterators.ResultSetIterator;
import org.echocat.jomon.runtime.util.ResourceUtils;

public abstract class StatementBasedQueryResultSetIterator<R>
extends ResultSetIterator<R> {
    private final Statement _statement;
    private final String _querySql;

    protected StatementBasedQueryResultSetIterator(@Nonnull Statement statement, @Nonnull String querySql) throws SQLException {
        this(statement, querySql, Integer.MIN_VALUE);
    }

    protected StatementBasedQueryResultSetIterator(@Nonnull Statement statement, @Nonnull String querySql, @Nullable Integer fetchSize) throws SQLException {
        super(StatementBasedQueryResultSetIterator.createResultSetFor(statement, querySql));
        this._statement = statement;
        this._querySql = querySql;
        if (fetchSize != null) {
            try {
                statement.setFetchSize(fetchSize);
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not set fetchSize to " + fetchSize + " at " + statement + ".", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected static ResultSet createResultSetFor(@Nonnull Statement statement, @Nonnull String sql) throws SQLException {
        boolean success = false;
        try {
            ResultSet resultSet = statement.executeQuery(sql);
            success = true;
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        finally {
            if (!success) {
                ResourceUtils.closeQuietly((AutoCloseable)statement);
            }
        }
    }

    @Override
    public void close() {
        try {
            ResourceUtils.closeQuietly((AutoCloseable)this._statement);
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "Iterator for '" + this._querySql + "'";
    }
}

