/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.echocat.jomon.runtime.logging.Cl2Slf4jLocationAwareLog;
import org.echocat.jomon.runtime.logging.Cl2Slf4jLog;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Cl2Slf4jLoggerFactory
extends LogFactory {
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    @Nonnull
    private final ILoggerFactory _loggerFactory;
    @Nonnull
    private final Map<String, Log> _loggerMap = new HashMap<String, Log>();
    @Nonnull
    private final Map<String, Object> _attributes = new HashMap<String, Object>();

    public Cl2Slf4jLoggerFactory(@Nullable ILoggerFactory loggerFactory) {
        this._loggerFactory = loggerFactory != null ? loggerFactory : LoggerFactory.getILoggerFactory();
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(String name) throws LogConfigurationException {
        Log instance;
        Map<String, Log> map = this._loggerMap;
        synchronized (map) {
            instance = this._loggerMap.get(name);
            if (instance == null) {
                Logger logger = this._loggerFactory.getLogger(name);
                instance = logger instanceof LocationAwareLogger ? new Cl2Slf4jLocationAwareLog((LocationAwareLogger)logger) : new Cl2Slf4jLog(logger);
                this._loggerMap.put(name, instance);
            }
        }
        return instance;
    }

    public void release() {
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this._attributes.remove(name);
        } else {
            this._attributes.put(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public String[] getAttributeNames() {
        Set<String> keys = this._attributes.keySet();
        return keys.toArray(new String[keys.size()]);
    }
}

