/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Jul2Slf4jHandler
extends Handler {
    private static final String FQCN = java.util.logging.Logger.class.getName();
    private static final String UNKNOWN_LOGGER_NAME = "unknown.jul.logger";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();
    @Nullable
    private final ILoggerFactory _loggerFactory;

    public Jul2Slf4jHandler() {
        this(null);
    }

    public Jul2Slf4jHandler(@Nullable ILoggerFactory loggerFactory) {
        this._loggerFactory = loggerFactory;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Nullable
    protected Logger getSLF4JLogger(@Nonnull LogRecord record) {
        String name = record.getLoggerName();
        return this.logger(name != null ? name : UNKNOWN_LOGGER_NAME);
    }

    protected void callLocationAwareLogger(LocationAwareLogger lal, LogRecord record) {
        int julLevelValue = record.getLevel().intValue();
        int slf4jLevel = julLevelValue <= TRACE_LEVEL_THRESHOLD ? 0 : (julLevelValue <= DEBUG_LEVEL_THRESHOLD ? 10 : (julLevelValue <= INFO_LEVEL_THRESHOLD ? 20 : (julLevelValue <= WARN_LEVEL_THRESHOLD ? 30 : 40)));
        String i18nMessage = this.getMessageI18N(record);
        lal.log(null, FQCN, slf4jLevel, i18nMessage, null, record.getThrown());
    }

    protected void callPlainSLF4JLogger(@Nonnull Logger slf4jLogger, LogRecord record) {
        String i18nMessage = this.getMessageI18N(record);
        int julLevelValue = record.getLevel().intValue();
        if (julLevelValue <= TRACE_LEVEL_THRESHOLD) {
            slf4jLogger.trace(i18nMessage, record.getThrown());
        } else if (julLevelValue <= DEBUG_LEVEL_THRESHOLD) {
            slf4jLogger.debug(i18nMessage, record.getThrown());
        } else if (julLevelValue <= INFO_LEVEL_THRESHOLD) {
            slf4jLogger.info(i18nMessage, record.getThrown());
        } else if (julLevelValue <= WARN_LEVEL_THRESHOLD) {
            slf4jLogger.warn(i18nMessage, record.getThrown());
        } else {
            slf4jLogger.error(i18nMessage, record.getThrown());
        }
    }

    @Nullable
    protected String getMessageI18N(@Nonnull LogRecord record) {
        String message = record.getMessage();
        if (message != null) {
            Object[] params;
            ResourceBundle bundle = record.getResourceBundle();
            if (bundle != null) {
                try {
                    message = bundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if ((params = record.getParameters()) != null && params.length > 0) {
                message = MessageFormat.format(message, params);
            }
        }
        return message;
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        if (record != null) {
            Logger slf4jLogger = this.getSLF4JLogger(record);
            if (slf4jLogger instanceof LocationAwareLogger) {
                this.callLocationAwareLogger((LocationAwareLogger)slf4jLogger, record);
            } else {
                this.callPlainSLF4JLogger(slf4jLogger, record);
            }
        }
    }

    @Nonnull
    protected Logger logger(@Nonnull String name) {
        return this._loggerFactory != null ? this._loggerFactory.getLogger(name) : LoggerFactory.getLogger((String)name);
    }
}

