/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.slf4j.Log4jLogger;
import org.echocat.jomon.runtime.logging.Log4J2BasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.Log4JBasedLoggingEnvironment;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactoryRegistry;

public class Log4J2BasedLoggingEnvironment
implements LoggingEnvironment {
    protected static final String FQCN = Log4J2BasedLoggingEnvironment.class.getName();
    public static final ClassLoader CLASS_LOADER = Log4JBasedLoggingEnvironment.class.getClassLoader();
    @Nullable
    private LoggerContextFactory _factory;
    @Nullable
    private LoggerContextFactory _originalFactory;
    @Nullable
    private ILoggerFactory _loggerFactory;
    @Nullable
    private LoggerFactoryRegistry.Registration _loggerFactoryRegistration;
    @Nullable
    private Slf4jUtils.Installation _installation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nonnull Log4J2BasedLoggingEnvironmentConfiguration with) {
        Log4J2BasedLoggingEnvironment log4J2BasedLoggingEnvironment = this;
        synchronized (log4J2BasedLoggingEnvironment) {
            if (this._factory == null) {
                this._originalFactory = this.findOriginalFactory();
                this._factory = new LoggerContextFactoryImpl(this.createLoggerContext(with));
                this._loggerFactory = new LoggerFactory(this._factory);
                LogManager.setFactory((LoggerContextFactory)this._factory);
                this._loggerFactoryRegistration = LoggerFactoryRegistry.register(this._loggerFactory);
                if (with.isInstallSl4jRequired()) {
                    this._installation = Slf4jUtils.tryInstallSlf4jBridges(this._loggerFactory);
                }
            }
        }
    }

    @Nonnull
    protected org.apache.logging.log4j.spi.LoggerContext createLoggerContext(@Nonnull Log4J2BasedLoggingEnvironmentConfiguration requirement) {
        LoggerContext result = new LoggerContext(FQCN);
        result.start(this.createConfigurationFor(requirement));
        return result;
    }

    @Nonnull
    protected Configuration createConfigurationFor(@Nonnull Log4J2BasedLoggingEnvironmentConfiguration requirement) {
        return ConfigurationFactory.getInstance().getConfiguration(this.createConfigurationSourceFor(requirement));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected ConfigurationSource createConfigurationSourceFor(@Nonnull Log4J2BasedLoggingEnvironmentConfiguration requirement) {
        try (InputStream is = requirement.openAsInputStream();){
            ConfigurationSource configurationSource = this.createConfigurationSourceFor(requirement, is);
            return configurationSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure log4j.", e);
        }
    }

    @Nonnull
    protected ConfigurationSource createConfigurationSourceFor(@Nonnull Log4J2BasedLoggingEnvironmentConfiguration requirement, @Nonnull InputStream is) throws IOException {
        return new ConfigurationSource(is);
    }

    @Nullable
    protected LoggerContextFactory findOriginalFactory() {
        return LogManager.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Log4J2BasedLoggingEnvironment log4J2BasedLoggingEnvironment = this;
        synchronized (log4J2BasedLoggingEnvironment) {
            if (this._factory != null) {
                try {
                    try {
                        try {
                            ResourceUtils.closeQuietly((AutoCloseable)this._installation);
                        }
                        finally {
                            this._installation = null;
                        }
                    }
                    finally {
                        try {
                            LogManager.setFactory((LoggerContextFactory)this._originalFactory);
                        }
                        finally {
                            try {
                                if (this._loggerFactoryRegistration != null) {
                                    this._loggerFactoryRegistration.close();
                                }
                            }
                            finally {
                                this._loggerFactoryRegistration = null;
                            }
                        }
                    }
                }
                finally {
                    this._loggerFactory = null;
                    this._factory = null;
                }
            }
        }
    }

    @Nonnull
    public LoggerContextFactory getFactory() {
        this.assertInitialized();
        return this._factory;
    }

    @Nullable
    public LoggerContextFactory getOriginalFactory() {
        this.assertInitialized();
        return this._originalFactory;
    }

    @Nonnull
    protected ILoggerFactory loggerFactory() {
        ILoggerFactory loggerFactory = this._loggerFactory;
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging environment currently not initialized.");
        }
        return loggerFactory;
    }

    protected void assertInitialized() {
        if (this._factory == null) {
            throw new IllegalStateException("Logging environment currently not initialized.");
        }
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull String name) {
        return this.loggerFactory().getLogger(name);
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull Class<?> type) {
        return this.getLogger(type.getName());
    }

    protected static class LoggerFactory
    implements ILoggerFactory {
        @Nonnull
        private final ConcurrentMap<String, Logger> _loggerMap = new ConcurrentHashMap<String, Logger>();
        @Nonnull
        private final LoggerContextFactory _factory;

        public LoggerFactory(@Nonnull LoggerContextFactory factory) {
            this._factory = factory;
        }

        public Logger getLogger(String name) {
            Logger result = (Logger)this._loggerMap.get(name);
            if (result == null) {
                ExtendedLogger log4jLogger = this._factory.getContext(FQCN, CLASS_LOADER, null, true).getLogger(name);
                Log4jLogger newInstance = new Log4jLogger(log4jLogger, name);
                Logger oldInstance = this._loggerMap.putIfAbsent(name, (Logger)newInstance);
                result = oldInstance == null ? newInstance : oldInstance;
            }
            return result;
        }
    }

    protected static class LoggerContextFactoryImpl
    implements LoggerContextFactory {
        @Nonnull
        private final org.apache.logging.log4j.spi.LoggerContext _loggerContext;

        public LoggerContextFactoryImpl(@Nonnull org.apache.logging.log4j.spi.LoggerContext loggerContext) {
            this._loggerContext = loggerContext;
        }

        public org.apache.logging.log4j.spi.LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
            return this._loggerContext;
        }

        public org.apache.logging.log4j.spi.LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
            return this._loggerContext;
        }

        public void removeContext(org.apache.logging.log4j.spi.LoggerContext context) {
        }
    }
}

