/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;
import org.echocat.jomon.runtime.logging.Log4JBasedLoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.Log4JUtils;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactoryRegistry;
import org.slf4j.impl.Log4jLoggerAdapter;

public class Log4JBasedLoggingEnvironment
implements LoggingEnvironment {
    @Nullable
    private RepositorySelector _selector;
    @Nullable
    private RepositorySelector _originalSelector;
    @Nullable
    private ILoggerFactory _loggerFactory;
    @Nullable
    private LoggerFactoryRegistry.Registration _loggerFactoryRegistration;
    @Nullable
    private Slf4jUtils.Installation _installation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@Nonnull Log4JBasedLoggingEnvironmentConfiguration with) {
        Log4JBasedLoggingEnvironment log4JBasedLoggingEnvironment = this;
        synchronized (log4JBasedLoggingEnvironment) {
            if (this._selector == null) {
                this._originalSelector = this.findOriginalSelector();
                this._selector = this.createSelectorFor(with);
                this._loggerFactory = new LoggerFactory(this._selector.getLoggerRepository());
                LogManager.setRepositorySelector((RepositorySelector)this._selector, null);
                this._loggerFactoryRegistration = LoggerFactoryRegistry.register(this._loggerFactory);
                if (with.isInstallSl4jRequired()) {
                    this._installation = Slf4jUtils.tryInstallSlf4jBridges(this._loggerFactory);
                }
            }
        }
    }

    @Nonnull
    protected RepositorySelector createSelectorFor(@Nonnull Log4JBasedLoggingEnvironmentConfiguration requirement) {
        return new DefaultRepositorySelector(this.createRepositoryFor(requirement));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected LoggerRepository createRepositoryFor(@Nonnull Log4JBasedLoggingEnvironmentConfiguration requirement) {
        try (Reader reader = requirement.openAsReader();){
            LoggerRepository loggerRepository = this.createRepositoryFor(requirement, reader);
            return loggerRepository;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configure log4j.", e);
        }
    }

    @Nonnull
    protected LoggerRepository createRepositoryFor(@Nonnull Log4JBasedLoggingEnvironmentConfiguration requirement, @Nonnull Reader reader) throws IOException {
        Hierarchy result = new Hierarchy((org.apache.log4j.Logger)new RootLogger(Level.INFO));
        Log4JUtils.configure(reader, (LoggerRepository)result);
        return result;
    }

    @Nullable
    protected RepositorySelector findOriginalSelector() {
        return new DefaultRepositorySelector(LogManager.getLoggerRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Log4JBasedLoggingEnvironment log4JBasedLoggingEnvironment = this;
        synchronized (log4JBasedLoggingEnvironment) {
            try {
                try {
                    ResourceUtils.closeQuietly((AutoCloseable)this._installation);
                }
                finally {
                    this._installation = null;
                }
            }
            finally {
                try {
                    try {
                        if (this._selector != null) {
                            LogManager.setRepositorySelector((RepositorySelector)this._originalSelector, null);
                        }
                    }
                    finally {
                        try {
                            ResourceUtils.closeQuietly((AutoCloseable)this._loggerFactoryRegistration);
                        }
                        finally {
                            this._loggerFactoryRegistration = null;
                        }
                    }
                }
                finally {
                    this._loggerFactory = null;
                    this._selector = null;
                }
            }
        }
    }

    @Nonnull
    public RepositorySelector getSelector() {
        this.assertInitialized();
        return this._selector;
    }

    @Nullable
    public RepositorySelector getOriginalSelector() {
        this.assertInitialized();
        return this._originalSelector;
    }

    @Nonnull
    protected ILoggerFactory loggerFactory() {
        ILoggerFactory loggerFactory = this._loggerFactory;
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging environment currently not initialized.");
        }
        return loggerFactory;
    }

    protected void assertInitialized() {
        if (this._selector == null) {
            throw new IllegalStateException("Logging environment currently not initialized.");
        }
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull String name) {
        return this.loggerFactory().getLogger(name);
    }

    @Override
    @Nonnull
    public Logger getLogger(@Nonnull Class<?> type) {
        return this.getLogger(type.getName());
    }

    protected static class LoggerFactory
    implements ILoggerFactory {
        @Nonnull
        private final ConcurrentMap<String, Logger> _loggerMap = new ConcurrentHashMap<String, Logger>();
        @Nonnull
        private final LoggerRepository _repository;

        public LoggerFactory(@Nonnull LoggerRepository repository) {
            this._repository = repository;
        }

        public Logger getLogger(String name) {
            Logger result = (Logger)this._loggerMap.get(name);
            if (result == null) {
                org.apache.log4j.Logger log4jLogger = name.equalsIgnoreCase("ROOT") ? this._repository.getRootLogger() : this._repository.getLogger(name);
                Logger newInstance = this.createLoggerFor(log4jLogger);
                Logger oldInstance = this._loggerMap.putIfAbsent(name, newInstance);
                result = oldInstance == null ? newInstance : oldInstance;
            }
            return result;
        }

        @Nonnull
        protected Logger createLoggerFor(@Nonnull org.apache.log4j.Logger original) {
            try {
                Constructor constructor = Log4jLoggerAdapter.class.getDeclaredConstructor(org.apache.log4j.Logger.class);
                constructor.setAccessible(true);
                return (Logger)constructor.newInstance(original);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Could not create logger adapter for log4j.", e.getTargetException());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not access logger adapter for log4j.", e);
            }
        }
    }
}

