/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import javax.annotation.Nonnull;

public interface LogLevel
extends Comparable<LogLevel> {
    public static final LogLevel trace = Impl.logLevel(LogLevel.class, 1000, "trace");
    public static final LogLevel debug = Impl.logLevel(LogLevel.class, 2000, "debug");
    public static final LogLevel info = Impl.logLevel(LogLevel.class, 3000, "info");
    public static final LogLevel warning = Impl.logLevel(LogLevel.class, 4000, "warning");
    public static final LogLevel error = Impl.logLevel(LogLevel.class, 5000, "error");
    public static final LogLevel fatal = Impl.logLevel(LogLevel.class, 6000, "fatal");

    public int getPriority();

    @Nonnull
    public String getName();

    public static class Impl
    implements LogLevel {
        private final int _priority;
        @Nonnull
        private final String _name;

        @Nonnull
        protected static LogLevel logLevel(@Nonnull Class<?> clazz, int defaultPriority, @Nonnull String name) {
            return Impl.logLevel(clazz.getName() + ".", defaultPriority, name);
        }

        @Nonnull
        protected static LogLevel logLevel(@Nonnull String propertyNamePrefix, int defaultPriority, @Nonnull String name) {
            int priority;
            String propertyName = propertyNamePrefix + name;
            String plainPriority = System.getProperty(propertyName, Integer.toString(defaultPriority));
            try {
                priority = plainPriority.isEmpty() ? defaultPriority : Integer.parseInt(plainPriority);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("System property '" + propertyName + "' contains in invalid priority value for logLevel '" + name + "'. Got: " + plainPriority, e);
            }
            return new Impl(priority, name);
        }

        @Nonnull
        protected static LogLevel logLevel(int priority, @Nonnull String name) {
            return new Impl(priority, name);
        }

        public Impl(int priority, @Nonnull String name) {
            this._priority = priority;
            this._name = name;
        }

        @Override
        public int getPriority() {
            return this._priority;
        }

        @Override
        @Nonnull
        public String getName() {
            return this._name;
        }

        @Override
        public int compareTo(LogLevel that) {
            return Integer.compare(this.getPriority(), that.getPriority());
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (o == null || this.getClass() != o.getClass()) {
                result = false;
            } else {
                LogLevel that = (LogLevel)o;
                result = this.getPriority() == that.getPriority();
            }
            return result;
        }

        public int hashCode() {
            return this.getPriority();
        }

        public String toString() {
            return this.getName();
        }
    }
}

