/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.logging.LogLevel;

public class LogLevels {
    @Nonnull
    private static final Set<LogLevel> DEFAULTS = CollectionUtils.addAllAndMakeImmutable(new TreeSet(), new LogLevel[]{LogLevel.trace, LogLevel.debug, LogLevel.info, LogLevel.warning, LogLevel.error, LogLevel.fatal});
    @Nonnull
    private static final Set<LogLevel> ALL = LogLevels.loadLevels(DEFAULTS);
    @Nonnull
    private static final Map<String, LogLevel> NAME_TO_LEVEL = LogLevels.asNameToLevel(ALL);
    @Nonnull
    private static final Map<Integer, LogLevel> PRIORITY_TO_LEVEL = LogLevels.asPriorityToLevel(ALL);

    @Nonnull
    public static Set<LogLevel> defaults() {
        return DEFAULTS;
    }

    @Nonnull
    public static Set<LogLevel> all() {
        return ALL;
    }

    @Nonnull
    public static Set<LogLevel> defaultLogLevels() {
        return LogLevels.defaults();
    }

    @Nonnull
    public static Set<LogLevel> allLogLevels() {
        return LogLevels.all();
    }

    @Nullable
    public static LogLevel findLogLevelBy(@Nonnull String name) {
        return NAME_TO_LEVEL.get(name);
    }

    @Nonnull
    public static LogLevel getLogLevelBy(@Nonnull String name) throws IllegalArgumentException {
        LogLevel logLevel = LogLevels.findLogLevelBy(name);
        if (logLevel == null) {
            throw new IllegalArgumentException("There is no logLevel named '" + name + "'.");
        }
        return logLevel;
    }

    @Nullable
    public static LogLevel findLogLevelBy(@Nonnull int priority) {
        return PRIORITY_TO_LEVEL.get(priority);
    }

    @Nonnull
    public static LogLevel getLogLevelBy(@Nonnull int priority) throws IllegalArgumentException {
        LogLevel logLevel = LogLevels.findLogLevelBy(priority);
        if (logLevel == null) {
            throw new IllegalArgumentException("There is no logLevel with priority " + priority + ".");
        }
        return logLevel;
    }

    @Nonnull
    protected static Set<LogLevel> loadLevels(@Nullable Iterable<LogLevel> defaultLevels) {
        TreeSet result = new TreeSet();
        CollectionUtils.addAll(result, defaultLevels);
        CollectionUtils.addAll(result, ServiceLoader.load(LogLevel.class));
        return CollectionUtils.asImmutableSet(result);
    }

    @Nonnull
    protected static Map<String, LogLevel> asNameToLevel(@Nonnull Iterable<LogLevel> logLevels) {
        HashMap<String, LogLevel> result = new HashMap<String, LogLevel>();
        for (LogLevel logLevel : logLevels) {
            String name = logLevel.getName();
            if (result.containsKey(name)) {
                throw new IllegalStateException("The name '" + name + "' was defined for more then one logLevels.");
            }
            result.put(name, logLevel);
        }
        return CollectionUtils.asImmutableMap(result);
    }

    @Nonnull
    protected static Map<Integer, LogLevel> asPriorityToLevel(@Nonnull Iterable<LogLevel> logLevels) {
        HashMap<Integer, LogLevel> result = new HashMap<Integer, LogLevel>();
        for (LogLevel logLevel : logLevels) {
            int priority = logLevel.getPriority();
            if (result.containsKey(priority)) {
                throw new IllegalStateException("The priority '" + priority + "' was defined for more then one logLevels.");
            }
            result.put(priority, logLevel);
        }
        return CollectionUtils.asImmutableMap(result);
    }

    private LogLevels() {
    }
}

