/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.logging.Jul2Slf4jHandler;
import org.echocat.jomon.runtime.logging.Log4JUtils;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.LogLevels;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jUtils {
    private static final String FQCN = Slf4jUtils.class.getName();
    private static final Map<LogLevel, LogLevel> NORMALIZED_LEVEL_CACHE = new ConcurrentHashMap<LogLevel, LogLevel>();

    public static void log(@Nonnull LocationAwareLogger logger, @Nonnull LogLevel level, @Nullable String fqcn, @Nullable Marker marker, @Nullable String message, @Nullable Object[] argArray, @Nullable Throwable t) {
        if (LogLevel.trace.equals(level)) {
            logger.log(marker, fqcn, 0, message, argArray, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.log(marker, fqcn, 10, message, argArray, t);
        } else if (LogLevel.info.equals(level)) {
            logger.log(marker, fqcn, 20, message, argArray, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.log(marker, fqcn, 30, message, argArray, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.log(marker, fqcn, 40, message, argArray, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), fqcn, marker, message, argArray, t);
        }
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull LogLevel level) {
        boolean result = LogLevel.trace.equals(level) ? logger.isTraceEnabled() : (LogLevel.debug.equals(level) ? logger.isDebugEnabled() : (LogLevel.info.equals(level) ? logger.isInfoEnabled() : (LogLevel.warning.equals(level) ? logger.isWarnEnabled() : (LogLevel.error.equals(level) || LogLevel.fatal.equals(level) ? logger.isErrorEnabled() : Slf4jUtils.isEnabled(logger, Slf4jUtils.normalize(level))))));
        return result;
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nullable String msg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, msg, null, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(msg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(msg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(msg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(msg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(msg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), msg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, @Nullable Object arg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, new Object[]{arg}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, new Object[]{arg1, arg2}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arg1, arg2);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arg1, arg2);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arg1, arg2);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arg1, arg2);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arg1, arg2);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arg1, arg2);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull String format, Object ... arguments) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, format, arguments, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(format, arguments);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(format, arguments);
        } else if (LogLevel.info.equals(level)) {
            logger.info(format, arguments);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(format, arguments);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(format, arguments);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), format, arguments);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nullable String msg, @Nullable Throwable t) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, null, msg, null, t);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(msg, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(msg, t);
        } else if (LogLevel.info.equals(level)) {
            logger.info(msg, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(msg, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(msg, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), msg, t);
        }
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker) {
        boolean result = LogLevel.trace.equals(level) ? logger.isTraceEnabled(marker) : (LogLevel.debug.equals(level) ? logger.isDebugEnabled(marker) : (LogLevel.info.equals(level) ? logger.isInfoEnabled(marker) : (LogLevel.warning.equals(level) ? logger.isWarnEnabled(marker) : (LogLevel.error.equals(level) || LogLevel.fatal.equals(level) ? logger.isErrorEnabled(marker) : Slf4jUtils.isEnabled(logger, Slf4jUtils.normalize(level), marker)))));
        return result;
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nullable String msg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, msg, null, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, msg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, msg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, msg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, msg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, msg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, msg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, @Nullable Object arg) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, new Object[]{arg}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arg);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arg);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arg);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arg);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arg);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arg);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, new Object[]{arg1, arg2}, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arg1, arg2);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arg1, arg2);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arg1, arg2);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arg1, arg2);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arg1, arg2);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arg1, arg2);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nonnull String format, Object ... arguments) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, format, arguments, null);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, format, arguments);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, format, arguments);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, format, arguments);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, format, arguments);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, format, arguments);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, format, arguments);
        }
    }

    public static void log(@Nonnull Logger logger, @Nonnull LogLevel level, @Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
        if (logger instanceof LocationAwareLogger) {
            Slf4jUtils.log((LocationAwareLogger)logger, level, FQCN, marker, msg, null, t);
        } else if (LogLevel.trace.equals(level)) {
            logger.trace(marker, msg, t);
        } else if (LogLevel.debug.equals(level)) {
            logger.debug(marker, msg, t);
        } else if (LogLevel.info.equals(level)) {
            logger.info(marker, msg, t);
        } else if (LogLevel.warning.equals(level)) {
            logger.warn(marker, msg, t);
        } else if (LogLevel.error.equals(level) || LogLevel.fatal.equals(level)) {
            logger.error(marker, msg, t);
        } else {
            Slf4jUtils.log(logger, Slf4jUtils.normalize(level), marker, msg, t);
        }
    }

    @Nonnull
    protected static LogLevel normalize(@Nonnull LogLevel level) {
        LogLevel result = NORMALIZED_LEVEL_CACHE.get(level);
        if (result == null) {
            result = LogLevel.debug;
            int lastDifference = Slf4jUtils.differenceOf(LogLevel.debug, level);
            for (LogLevel logLevel : LogLevels.allLogLevels()) {
                int difference = Slf4jUtils.differenceOf(logLevel, level);
                if (difference >= lastDifference) continue;
                result = logLevel;
                lastDifference = difference;
            }
            NORMALIZED_LEVEL_CACHE.put(level, result);
        }
        return result;
    }

    @Nonnegative
    protected static int differenceOf(@Nonnull LogLevel a, @Nonnull LogLevel b) {
        int pb;
        int pa = a.getPriority();
        int result = pa == (pb = b.getPriority()) ? 0 : (pa > pb ? pa - pb : pb - pa);
        return result;
    }

    private Slf4jUtils() {
    }

    @Nonnull
    public static Installation tryInstallSlf4jBridges(@Nullable ILoggerFactory loggerFactory) {
        return new CombinedInstallation(new Installation[]{Slf4jUtils.tryInstallClToSlf4jBridge(loggerFactory), Slf4jUtils.tryInstallJulToSlf4jBridge(loggerFactory)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Installation tryInstallClToSlf4jBridge(@Nullable ILoggerFactory loggerFactory) {
        Installation result;
        block5: {
            result = new NoopInstallation();
            try {
                Map factories;
                Class<?> type = Slf4jUtils.class.getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
                Field field = type.getDeclaredField("factories");
                field.setAccessible(true);
                if (!Map.class.isAssignableFrom(field.getType()) || (factories = (Map)field.get(null)) == null) break block5;
                Map map = factories;
                synchronized (map) {
                    ClassLoader classLoader = Slf4jUtils.classLoader();
                    factories.put(classLoader, Slf4jUtils.createClToSlf4jLoggerFactoryFor(loggerFactory));
                    result = new Cl2Slf4jInstallation(factories, classLoader);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return result;
    }

    @Nonnull
    private static Object createClToSlf4jLoggerFactoryFor(@Nullable ILoggerFactory loggerFactory) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Class<?> type = Slf4jUtils.classLoader().loadClass("org.echocat.jomon.runtime.logging.Cl2Slf4jLoggerFactory");
            return type.getConstructor(ILoggerFactory.class).newInstance(loggerFactory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            PrintStream stream = System.err;
            stream.print("WARN Could not initiate instance of org.echocat.jomon.runtime.logging.Cl2Slf4jLoggerFactory.");
            e.printStackTrace(stream);
            throw e;
        }
    }

    @Nonnull
    protected static ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Nonnull
    public static Installation tryInstallJulToSlf4jBridge() {
        return Slf4jUtils.tryInstallJulToSlf4jBridge(null);
    }

    @Nonnull
    public static Installation tryInstallJulToSlf4jBridge(@Nullable ILoggerFactory loggerFactory) {
        return Slf4jUtils.tryInstallJulToSlf4jBridge(loggerFactory, null);
    }

    @Nonnull
    public static Installation tryInstallJulToSlf4jBridge(@Nullable ILoggerFactory loggerFactory, @Nullable LogManager logManager) {
        Jul2Slf4jHandler newHandler = new Jul2Slf4jHandler(loggerFactory);
        LogManager manager = logManager != null ? logManager : LogManager.getLogManager();
        manager.reset();
        java.util.logging.Logger logger = manager.getLogger("");
        ArrayList<Jul2Slf4jHandler> originalHandlers = new ArrayList<Jul2Slf4jHandler>();
        for (Handler oldHandlers : logger.getHandlers()) {
            logger.removeHandler(oldHandlers);
            originalHandlers.add(newHandler);
        }
        logger.addHandler(newHandler);
        return new Jul2Slf4jInstallation(originalHandlers, newHandler, manager);
    }

    public static void tryFixMdcInSlf4j() {
        try {
            ClassLoader classLoader = Log4JUtils.class.getClassLoader();
            Class<?> mdc = classLoader.loadClass("org.slf4j.MDC");
            Class<?> mdcAdapter = classLoader.loadClass("org.slf4j.spi.MDCAdapter");
            Field mdcAdapterField = mdc.getDeclaredField("mdcAdapter");
            if (mdcAdapterField.getType().equals(mdcAdapter)) {
                mdcAdapterField.setAccessible(true);
                Object delegate = mdcAdapterField.get(null);
                Object fixed = classLoader.loadClass("org.echocat.jomon.runtime.logging.FixingSlf4jMDCAdapter").getConstructor(mdcAdapter).newInstance(delegate);
                mdcAdapterField.set(null, fixed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Jul2Slf4jInstallation
    implements Installation {
        @Nonnull
        private final Iterable<Handler> _originalHandlers;
        @Nonnull
        private final Handler _installedHandler;
        @Nonnull
        private final LogManager _logManager;

        private Jul2Slf4jInstallation(@Nonnull Iterable<Handler> originalHandlers, @Nonnull Handler installedHandler, @Nonnull LogManager logManager) {
            this._originalHandlers = originalHandlers;
            this._installedHandler = installedHandler;
            this._logManager = logManager;
        }

        @Override
        public void close() throws Exception {
            java.util.logging.Logger root = this._logManager.getLogger("");
            this._logManager.reset();
            root.removeHandler(this._installedHandler);
            for (Handler originalHandler : this._originalHandlers) {
                root.addHandler(originalHandler);
            }
        }
    }

    private static class Cl2Slf4jInstallation
    implements Installation {
        @Nonnull
        private final Map<ClassLoader, Object> _factories;
        @Nonnull
        private final ClassLoader _classLoader;

        private Cl2Slf4jInstallation(@Nonnull Map<ClassLoader, Object> factories, @Nonnull ClassLoader classLoader) {
            this._factories = factories;
            this._classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            Map<ClassLoader, Object> map = this._factories;
            synchronized (map) {
                this._factories.remove(this._classLoader);
            }
        }
    }

    private static class CombinedInstallation
    implements Installation {
        @Nonnull
        private final Iterable<Installation> _installations;

        private CombinedInstallation(Installation ... installations) {
            this(CollectionUtils.asImmutableList(installations));
        }

        private CombinedInstallation(@Nonnull Iterable<Installation> installations) {
            this._installations = installations;
        }

        @Override
        public void close() throws Exception {
            ResourceUtils.closeQuietlyIfAutoCloseable(this._installations);
        }
    }

    private static class NoopInstallation
    implements Installation {
        private NoopInstallation() {
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static interface Installation
    extends AutoCloseable {
    }
}

