/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.math;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.util.Duration;

@ThreadSafe
@Immutable
public abstract class OverPeriodAverageCounter<T> {
    protected static final int MAX_NUMBER_OF_MEASURE_POINTS = 10000;
    private final long _measurePeriod;
    private final long _resolution;
    private final Object[] _measuredValues;
    private final Long[] _measuredCounts;
    private final Long[] _measuredBaseTimes;
    private final T _zeroValue;

    protected OverPeriodAverageCounter(@Nonnull Duration measurePeriod, @Nonnull Duration resolution) {
        if (measurePeriod.isLessThan(resolution)) {
            throw new IllegalArgumentException("The given measure period have to be larger or equal than the resolution.");
        }
        this._measurePeriod = measurePeriod.in(TimeUnit.MILLISECONDS);
        this._resolution = resolution.in(TimeUnit.MILLISECONDS) - measurePeriod.in(TimeUnit.MILLISECONDS) % resolution.in(TimeUnit.MILLISECONDS);
        long measurePointsCount = this._measurePeriod / this._resolution;
        if (measurePointsCount > 10000L) {
            throw new IllegalArgumentException("The difference between measurePeriod and resolution is to high. Do not reach measurePeriod/resolution > 10000.");
        }
        this._measuredValues = new Object[(int)measurePointsCount];
        this._measuredCounts = new Long[(int)measurePointsCount];
        this._measuredBaseTimes = new Long[(int)measurePointsCount];
        this._zeroValue = this.getZeroValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(@Nonnull T value) {
        long currentTime = System.currentTimeMillis();
        long currentPositionInPeriod = currentTime % this._measurePeriod;
        int i = (int)(currentPositionInPeriod / this._resolution);
        long measuredPeriodBaseTime = currentTime / this._measurePeriod * this._measurePeriod;
        long measuredBaseTime = measuredPeriodBaseTime + (long)i * this._resolution;
        OverPeriodAverageCounter overPeriodAverageCounter = this;
        synchronized (overPeriodAverageCounter) {
            if (this._measuredValues[i] == null || this._measuredCounts[i] == null || this._measuredBaseTimes[i] == null || this._measuredBaseTimes[i] != measuredBaseTime && this._measuredBaseTimes[i] + this._measurePeriod < currentTime) {
                this._measuredValues[i] = this._zeroValue;
                this._measuredCounts[i] = 0L;
                this._measuredBaseTimes[i] = measuredBaseTime;
            }
            this._measuredValues[i] = this.add(value, this._measuredValues[i]);
            Long[] longArray = this._measuredCounts;
            Long l = longArray[i];
            Long l2 = longArray[i] = Long.valueOf(longArray[i] + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public T get() {
        long currentTime = System.currentTimeMillis();
        Object sumOfMeasuredValues = this._zeroValue;
        long sumOfMeasuredValueCounts = 0L;
        OverPeriodAverageCounter overPeriodAverageCounter = this;
        synchronized (overPeriodAverageCounter) {
            for (int i = 0; i < this._measuredCounts.length; ++i) {
                if (this._measuredBaseTimes[i] == null || this._measuredBaseTimes[i] + this._measurePeriod < currentTime || this._measuredCounts[i] <= 0L) continue;
                sumOfMeasuredValues = this.add(this._measuredValues[i], sumOfMeasuredValues);
                sumOfMeasuredValueCounts += this._measuredCounts[i].longValue();
            }
        }
        return this.averageFor(sumOfMeasuredValues, sumOfMeasuredValueCounts);
    }

    @Nonnull
    public Duration getMeasurePeriod() {
        return new Duration(this._measurePeriod);
    }

    @Nonnull
    public Duration getResolution() {
        return new Duration(this._resolution);
    }

    @Nonnegative
    public int getNumberOfMeasureSlots() {
        return this._measuredValues.length;
    }

    @Nonnull
    protected abstract T getZeroValue();

    @Nonnull
    protected abstract T add(@Nonnull T var1, @Nonnull T var2);

    @Nonnull
    protected abstract T averageFor(@Nonnull T var1, @Nonnegative long var2);

    public String toString() {
        return "Average of " + this.get() + " measured in " + this.getMeasurePeriod();
    }
}

