/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.NumberRange;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class LongRange
extends NumberRange<Long> {
    public LongRange(@Nullable @Including Long from, @Nullable @Excluding Long to) {
        super(from, to);
    }

    @Override
    protected boolean isGreaterThan(@Nonnull Long what, @Nonnull Long as) {
        return what > as;
    }

    @Override
    public boolean isSignificant(@Nonnull Long minValue, @Nonnull Long maxValue, @Nonnull Long base) {
        Long from = (Long)this.getFrom();
        Long to = (Long)this.getTo();
        long range = (to != null ? to : maxValue) - (from != null ? from : minValue);
        return range <= base;
    }

    public static class Adapter
    extends NumberRange.Adapter<Long, Container, LongRange> {
        @Override
        @Nonnull
        protected Container newContainer() {
            return new Container();
        }

        @Override
        @Nonnull
        protected LongRange newNumberRange(@Nullable @Including Long from, @Nullable @Excluding Long to) {
            return new LongRange(from, to);
        }
    }

    @XmlRootElement(name="longRange")
    @XmlType(name="longRangeType")
    public static class Container
    extends NumberRange.Container<Long> {
        @Override
        @XmlAttribute(name="from")
        public Long getFrom() {
            return (Long)super.getFrom();
        }

        @Override
        public void setFrom(Long from) {
            super.setFrom(from);
        }

        @Override
        @XmlAttribute(name="to")
        public Long getTo() {
            return (Long)super.getTo();
        }

        @Override
        public void setTo(Long to) {
            super.setTo(to);
        }
    }
}

