/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.numbers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.NumberRange;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class ShortRange
extends NumberRange<Short> {
    public ShortRange(@Nullable @Including Short from, @Nullable @Excluding Short to) {
        super(from, to);
    }

    @Override
    protected boolean isGreaterThan(@Nonnull Short what, @Nonnull Short as) {
        return what > as;
    }

    @Override
    public boolean isSignificant(@Nonnull Short minValue, @Nonnull Short maxValue, @Nonnull Short base) {
        Short from = (Short)this.getFrom();
        Short to = (Short)this.getTo();
        int range = (to != null ? to : maxValue) - (from != null ? from : minValue);
        return range <= base;
    }

    public static class Adapter
    extends NumberRange.Adapter<Short, Container, ShortRange> {
        @Override
        @Nonnull
        protected Container newContainer() {
            return new Container();
        }

        @Override
        @Nonnull
        protected ShortRange newNumberRange(@Nullable @Including Short from, @Nullable @Excluding Short to) {
            return new ShortRange(from, to);
        }
    }

    @XmlRootElement(name="shortRange")
    @XmlType(name="shortRangeType")
    public static class Container
    extends NumberRange.Container<Short> {
        @Override
        @XmlAttribute(name="from")
        public Short getFrom() {
            return (Short)super.getFrom();
        }

        @Override
        public void setFrom(Short from) {
            super.setFrom(from);
        }

        @Override
        @XmlAttribute(name="to")
        public Short getTo() {
            return (Short)super.getTo();
        }

        @Override
        public void setTo(Short to) {
            super.setTo(to);
        }
    }
}

