/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.StringUtils;
import org.echocat.jomon.runtime.util.ByteUnit;

@ThreadSafe
@Immutable
public class ByteCount
implements Comparable<ByteCount>,
Serializable {
    public static final int DEFAULT_FORMAT_PRECISION = 2;
    private static final ByteUnit[] BYTE_UNITS = ByteUnit.values();
    private static final Pattern SPLIT_PATTERN = ByteCount.createSplitPattern();
    private static final long serialVersionUID = 1L;
    private final long _count;

    @Nonnegative
    public static long toByteCount(@Nonnull String combinedByteCount) throws IllegalArgumentException {
        long result = 0L;
        if (!combinedByteCount.trim().equals("0")) {
            Matcher matcher = SPLIT_PATTERN.matcher(combinedByteCount);
            int lastEnd = 0;
            while (matcher.find()) {
                if (matcher.start() != lastEnd) {
                    throw new IllegalArgumentException("Could not parse: " + combinedByteCount);
                }
                lastEnd = matcher.end();
                result += ByteCount.parsePartValueOf(matcher);
            }
            if (lastEnd != combinedByteCount.length()) {
                throw new IllegalArgumentException("Could not parse: " + combinedByteCount);
            }
        }
        return result;
    }

    @Nonnegative
    protected static long parsePartValueOf(@Nonnull Matcher matcher) {
        Long partValue = null;
        for (int i = 0; i < BYTE_UNITS.length; ++i) {
            String group = matcher.group(i + 1);
            if (StringUtils.isEmpty((CharSequence)group)) continue;
            partValue = BYTE_UNITS[i].toBytes(Long.parseLong(group));
        }
        if (partValue == null || partValue < 0L) {
            throw new IllegalArgumentException("Could not parse part: " + matcher.group());
        }
        return partValue;
    }

    @Nonnull
    public static String toCombinedByteCount(@Nonnegative long byteCount) {
        StringBuilder sb = new StringBuilder();
        long rest = byteCount;
        for (int i = BYTE_UNITS.length - 1; i >= 0; --i) {
            ByteUnit unit = BYTE_UNITS[i];
            long value = unit.convert(rest, ByteUnit.BYTE);
            if (value <= 0L) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(value).append(unit.getDisplay());
            rest -= unit.toBytes(value);
        }
        if (sb.length() == 0) {
            sb.append('0');
        }
        return sb.toString();
    }

    @Nullable
    public static ByteCount byteCount(@Nullable String byteCount) {
        return byteCount != null ? new ByteCount(byteCount) : null;
    }

    @Nonnull
    public static ByteCount byteCount(@Nonnegative long byteCount) {
        return new ByteCount(byteCount);
    }

    @Nonnull
    public static ByteCount byteCount(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        return new ByteCount(byteCount, unit);
    }

    @Nullable
    public static ByteCount byteCountOf(@Nullable String byteCount) {
        return ByteCount.byteCount(byteCount);
    }

    @Nonnull
    public static ByteCount byteCountOf(@Nonnegative long byteCount) {
        return ByteCount.byteCount(byteCount);
    }

    @Nonnull
    public static ByteCount byteCountOf(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        return ByteCount.byteCount(byteCount, unit);
    }

    @Nonnull
    public static byte[] allocate(@Nonnull String byteCount) {
        return ByteCount.byteCount(byteCount).allocate();
    }

    @Nonnull
    public static byte[] allocate(@Nonnegative long byteCount) {
        return ByteCount.byteCount(byteCount).allocate();
    }

    @Nonnull
    public static byte[] allocate(@Nonnegative ByteCount byteCount) {
        return byteCount.allocate();
    }

    @Nonnull
    public static byte[] allocate(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        return ByteCount.byteCount(byteCount, unit).allocate();
    }

    @Nonnull
    public static ByteBuffer allocateBuffer(@Nonnull String byteCount) {
        return ByteCount.byteCount(byteCount).allocateBuffer();
    }

    @Nonnull
    public static ByteBuffer allocateBuffer(@Nonnegative long byteCount) {
        return ByteCount.byteCount(byteCount).allocateBuffer();
    }

    @Nonnull
    public static ByteBuffer allocateBuffer(@Nonnegative ByteCount byteCount) {
        return byteCount.allocateBuffer();
    }

    @Nonnull
    public static ByteBuffer allocateBuffer(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        return ByteCount.byteCount(byteCount, unit).allocateBuffer();
    }

    public ByteCount(@Nonnegative long byteCount) {
        this._count = byteCount;
    }

    public ByteCount(@Nonnegative long count, @Nonnull ByteUnit byteUnit) {
        this._count = byteUnit.toBytes(count);
    }

    public ByteCount(@Nonnull String combinedByteCount) throws IllegalArgumentException {
        this._count = ByteCount.toByteCount(combinedByteCount);
    }

    @Nonnegative
    public long toByteCount() {
        return this._count;
    }

    @Nonnull
    public byte[] allocate() {
        return new byte[this.toByteCountForAllocation()];
    }

    @Nonnull
    public ByteBuffer allocateBuffer() {
        return ByteBuffer.allocate(this.toByteCountForAllocation());
    }

    @Nonnegative
    public int toByteCountForAllocation() throws UnsupportedOperationException {
        if (this._count > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("This byteCount exceeds " + ByteCount.byteCount(Integer.MAX_VALUE) + " and could not be allocated.");
        }
        return (int)this._count;
    }

    @Nonnegative
    public long in(@Nonnull ByteUnit byteUnit) {
        return byteUnit.convert(this._count, ByteUnit.BYTE);
    }

    @Nonnull
    public String toCombinedByteCount() {
        return ByteCount.toCombinedByteCount(this._count);
    }

    @Nonnull
    public String toFormattedByteCountOf(@Nonnull ByteUnit unit) {
        return this.toFormattedByteCountOf(unit, null, 2);
    }

    @Nonnull
    public String toFormattedByteCountOf(@Nonnull ByteUnit unit, @Nonnegative int precision) {
        return this.toFormattedByteCountOf(unit, null, precision);
    }

    @Nonnull
    public String toFormattedByteCountOf(@Nonnull ByteUnit unit, @Nullable Locale locale) {
        return this.toFormattedByteCountOf(unit, locale, 2);
    }

    @Nonnull
    public String toFormattedByteCountOf(@Nonnull ByteUnit unit, @Nullable Locale locale, @Nonnegative int precision) {
        double value = unit.convert((double)this._count, ByteUnit.BYTE);
        NumberFormat format = DecimalFormat.getNumberInstance(locale != null ? locale : Locale.US);
        format.setMaximumFractionDigits(precision);
        return format.format(value) + unit.getDisplay();
    }

    @Nonnull
    public String toFormattedByteCount() {
        return this.toFormattedByteCount(null, 2);
    }

    @Nonnull
    public String toFormattedByteCount(@Nonnegative int precision) {
        return this.toFormattedByteCount(null, precision);
    }

    @Nonnull
    public String toFormattedByteCount(@Nullable Locale locale) {
        return this.toFormattedByteCount(locale, 2);
    }

    @Nonnull
    public String toFormattedByteCount(@Nullable Locale locale, @Nonnegative int precision) {
        return this.toFormattedByteCountOf(this.getBestFittingUnit(), locale, precision);
    }

    @Nonnull
    public ByteUnit getBestFittingUnit() {
        ByteUnit result = ByteUnit.BYTE;
        for (int i = BYTE_UNITS.length - 1; i >= 0; --i) {
            ByteUnit unit = BYTE_UNITS[i];
            if (unit.convert(this._count, ByteUnit.BYTE) <= 0L) continue;
            result = unit;
            break;
        }
        return result;
    }

    @Nonnull
    public ByteCount plus(@Nonnegative long byteCount) {
        return new ByteCount(this._count + byteCount);
    }

    @Nonnull
    public ByteCount plus(@Nullable ByteCount byteCount) {
        return this.plus(byteCount != null ? byteCount._count : 0L);
    }

    @Nonnull
    public ByteCount plus(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        long countToTransform = byteCount >= 0L ? byteCount : byteCount * -1L;
        long transformedCount = unit.toBytes(countToTransform);
        long correctedCount = byteCount >= 0L ? transformedCount : transformedCount * -1L;
        return this.plus(correctedCount);
    }

    @Nonnull
    public ByteCount plus(@Nullable String byteCount) {
        return this.plus(byteCount != null ? new ByteCount(byteCount) : null);
    }

    @Nonnull
    public ByteCount minus(@Nullable ByteCount byteCount) {
        return this.minus(byteCount != null ? byteCount._count : 0L);
    }

    @Nonnull
    public ByteCount minus(@Nonnegative long byteCount) {
        return new ByteCount(this._count - byteCount);
    }

    @Nonnull
    public ByteCount minus(@Nonnegative long byteCount, @Nonnull ByteUnit unit) {
        long countToTransform = byteCount >= 0L ? byteCount : byteCount * -1L;
        long transformedCount = unit.toBytes(countToTransform);
        long correctedCount = byteCount >= 0L ? transformedCount : transformedCount * -1L;
        return this.minus(correctedCount);
    }

    @Nonnull
    public ByteCount multiplyBy(double what) {
        return new ByteCount(Math.round((double)this.toByteCount() * what));
    }

    @Nonnull
    public ByteCount dividedBy(double what) {
        return new ByteCount(Math.round((double)this.toByteCount() / what));
    }

    @Nonnull
    public ByteCount multiplyBy(long what) {
        return new ByteCount(Math.round(this.toByteCount() * what));
    }

    @Nonnull
    public ByteCount dividedBy(long what) {
        return new ByteCount(Math.round(this.toByteCount() / what));
    }

    @Nonnegative
    public double getProcessInRelationTo(@Nonnull ByteCount current) {
        return (double)current._count / (double)this._count;
    }

    public boolean isEmpty() {
        return this.toByteCount() <= 0L;
    }

    public boolean hasContent() {
        return this.toByteCount() > 0L;
    }

    public boolean isLessThan(@Nonnull ByteCount other) {
        return this.toByteCount() < other.toByteCount();
    }

    public boolean isLessThanOrEqualTo(@Nonnull ByteCount other) {
        return this.toByteCount() <= other.toByteCount();
    }

    public boolean isGreaterThan(@Nonnull ByteCount other) {
        return this.toByteCount() > other.toByteCount();
    }

    public boolean isGreaterThanOrEqualTo(@Nonnull ByteCount other) {
        return this.toByteCount() >= other.toByteCount();
    }

    @Override
    public int compareTo(@Nonnull ByteCount other) {
        int result = ByteCount.compare(this.toByteCount(), other.toByteCount());
        return result;
    }

    private static int compare(long self, long other) {
        int result = self < other ? -1 : (self == other ? 0 : 1);
        return result;
    }

    public int hashCode() {
        return (int)(this._count ^ this._count >>> 32);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o instanceof ByteCount) {
            ByteCount other = (ByteCount)o;
            result = this.toByteCount() == other.toByteCount();
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return this.toCombinedByteCount();
    }

    @Nonnull
    private static Pattern createSplitPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\s*(?:");
        boolean first = true;
        for (ByteUnit byteUnit : BYTE_UNITS) {
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append("(\\d+)\\s*(?:").append(byteUnit.getDisplay()).append('|').append(byteUnit.getShortDisplay()).append(')');
        }
        sb.append(")\\s*");
        return Pattern.compile(sb.toString(), 2);
    }
}

