/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public enum ByteUnit {
    BYTE("B", "B"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toBytes(count) / 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) / 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) / 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) / 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) / 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toBytes(count) / 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) / 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) / 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) / 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) / 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toBytes(count);
        }
    }
    ,
    KILO_BYTE("kB", "k"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) / 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) / 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) / 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) / 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toKiloBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) / 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) / 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) / 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) / 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toKiloBytes(count);
        }
    }
    ,
    MEGA_BYTE("MB", "M"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) * 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) / 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) / 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) / 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toMegaBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) * 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) / 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) / 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) / 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toMegaBytes(count);
        }
    }
    ,
    GIGA_BYTE("GB", "G"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) * 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) * 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) / 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) / 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toGigaBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) * 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) * 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) / 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) / 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toGigaBytes(count);
        }
    }
    ,
    TERA_BYTE("TB", "T"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) * 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) * 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) * 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) / 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toTeraBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) * 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) * 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) * 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) / 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toTeraBytes(count);
        }
    }
    ,
    PETA_BYTE("PB", "P"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) * 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) * 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) * 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) * 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) / 1024L;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toPetaBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) * 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) * 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) * 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) * 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) / 1024.0;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toPetaBytes(count);
        }
    }
    ,
    EXA_BYTE("EB", "E"){

        @Override
        public long toBytes(@Nonnegative long count) {
            return this.toKiloBytes(count) * 1024L;
        }

        @Override
        public long toKiloBytes(@Nonnegative long count) {
            return this.toMegaBytes(count) * 1024L;
        }

        @Override
        public long toMegaBytes(@Nonnegative long count) {
            return this.toGigaBytes(count) * 1024L;
        }

        @Override
        public long toGigaBytes(@Nonnegative long count) {
            return this.toTeraBytes(count) * 1024L;
        }

        @Override
        public long toTeraBytes(@Nonnegative long count) {
            return this.toPetaBytes(count) * 1024L;
        }

        @Override
        public long toPetaBytes(@Nonnegative long count) {
            return this.toExaBytes(count) * 1024L;
        }

        @Override
        public long toExaBytes(@Nonnegative long count) {
            return count;
        }

        @Override
        public long convert(@Nonnegative long count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toExaBytes(count);
        }

        @Override
        public double toBytes(@Nonnegative double count) {
            return this.toKiloBytes(count) * 1024.0;
        }

        @Override
        public double toKiloBytes(@Nonnegative double count) {
            return this.toMegaBytes(count) * 1024.0;
        }

        @Override
        public double toMegaBytes(@Nonnegative double count) {
            return this.toGigaBytes(count) * 1024.0;
        }

        @Override
        public double toGigaBytes(@Nonnegative double count) {
            return this.toTeraBytes(count) * 1024.0;
        }

        @Override
        public double toTeraBytes(@Nonnegative double count) {
            return this.toPetaBytes(count) * 1024.0;
        }

        @Override
        public double toPetaBytes(@Nonnegative double count) {
            return this.toExaBytes(count) * 1024.0;
        }

        @Override
        public double toExaBytes(@Nonnegative double count) {
            return count;
        }

        @Override
        public double convert(@Nonnegative double count, @Nonnull ByteUnit sourceUnit) {
            return sourceUnit.toExaBytes(count);
        }
    };

    private final String _display;
    private final String _shortDisplay;

    @Nonnull
    public static ByteUnit getByDisplay(@Nonnull String display) throws IllegalArgumentException {
        for (ByteUnit unit : ByteUnit.values()) {
            if (!unit.getDisplay().equals(display) && (unit != BYTE || !"".equals(display))) continue;
            return unit;
        }
        throw new IllegalArgumentException();
    }

    @Nonnull
    public static ByteUnit getByShortDisplay(@Nonnull String shortDisplay) throws IllegalArgumentException {
        for (ByteUnit unit : ByteUnit.values()) {
            if (!unit.getShortDisplay().equals(shortDisplay) && (unit != BYTE || !"".equals(shortDisplay))) continue;
            return unit;
        }
        throw new IllegalArgumentException();
    }

    private ByteUnit(String display, String shortDisplay) {
        this._display = display;
        this._shortDisplay = shortDisplay;
    }

    @Nonnegative
    public abstract long convert(@Nonnegative long var1, @Nonnull ByteUnit var3);

    @Nonnegative
    public abstract double convert(@Nonnegative double var1, @Nonnull ByteUnit var3);

    @Nonnegative
    public abstract long toBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toKiloBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toMegaBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toGigaBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toTeraBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toPetaBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract long toExaBytes(@Nonnegative long var1);

    @Nonnegative
    public abstract double toBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toKiloBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toMegaBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toGigaBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toTeraBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toPetaBytes(@Nonnegative double var1);

    @Nonnegative
    public abstract double toExaBytes(@Nonnegative double var1);

    @Nonnull
    public String getDisplay() {
        return this._display;
    }

    @Nonnull
    public String getShortDisplay() {
        return this._shortDisplay;
    }

    public String toString() {
        return this._display;
    }
}

