/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Consumer<V, T extends Throwable> {
    public void consume(@Nullable V var1) throws T;

    public static class ExceptionThrowing<V, T extends Throwable>
    implements Consumer<V, T> {
        @Nullable
        private final T _throwable;
        @Nullable
        private final Class<T> _throwableType;
        @Nullable
        private final String _message;

        @Nonnull
        public static <V, T extends Throwable> Consumer<V, T> consumeAndThrow(@Nonnull T e) {
            return new ExceptionThrowing<V, T>(e);
        }

        @Nonnull
        public static <V, T extends Throwable> Consumer<V, T> consumeAndThrow(@Nonnull Class<T> type) {
            return ExceptionThrowing.consumeAndThrow(type, null);
        }

        @Nonnull
        public static <V, T extends Throwable> Consumer<V, T> consumeAndThrow(@Nonnull Class<T> type, @Nullable String message) {
            return new ExceptionThrowing<V, T>(type, message);
        }

        public ExceptionThrowing(@Nonnull T throwable) {
            this._throwable = throwable;
            this._throwableType = null;
            this._message = null;
        }

        public ExceptionThrowing(@Nonnull Class<T> throwableType, @Nullable String message) {
            this._throwableType = throwableType;
            this._message = message;
            this._throwable = null;
        }

        @Override
        public void consume(@Nullable V value) throws T {
            Object target;
            if (this._throwable != null) {
                target = this._throwable;
            } else if (this._throwableType != null) {
                try {
                    target = (Throwable)this._throwableType.getConstructor(String.class).newInstance(this._message);
                }
                catch (NoSuchMethodException ignored) {
                    if (this._message == null) {
                        try {
                            target = (Throwable)this._throwableType.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (NoSuchMethodException ignored2) {
                            throw new IllegalArgumentException("Could not find the constructor " + this._throwableType.getName() + "." + this._throwableType.getSimpleName() + "([message:" + String.class.getName() + "]).");
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not create a exception of type '" + this._throwableType.getName() + "'.", e);
                        }
                    }
                    throw new IllegalArgumentException("Could not find the constructor " + this._throwableType.getName() + "." + this._throwableType.getSimpleName() + "(message:" + String.class.getName() + ").");
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create a exception of type '" + this._throwableType.getName() + "' with message '" + this._message + "'.", e);
                }
            } else {
                throw new IllegalStateException("This statement could not be. There must be throwable or a throwableType provided.");
            }
            throw target;
        }
    }

    public static class Noop<V, T extends Throwable>
    implements Consumer<V, T> {
        @Nonnull
        private static final Noop<?, ?> INSTANCE = new Noop();

        @Nonnull
        public static <V, T extends Throwable> Consumer<V, T> consumeAndIgnore() {
            return INSTANCE;
        }

        @Override
        public void consume(@Nullable V value) throws T {
        }
    }
}

