/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.RangeSupport;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class DurationRange
extends RangeSupport<Duration> {
    public DurationRange(@Nullable @Including String from, @Nullable @Excluding String to) {
        super(from != null ? new Duration(from) : null, to != null ? new Duration(to) : null);
    }

    public DurationRange(@Nullable @Including Long from, @Nullable @Excluding Long to) {
        super(from != null ? new Duration(from) : null, to != null ? new Duration(to) : null);
    }

    public DurationRange(@Nullable @Including Duration from, @Nullable @Excluding Duration to) {
        super(from, to);
    }

    public boolean apply(@Nullable Duration toTest) {
        return toTest != null && this.matchesFrom(toTest) && this.matchesTo(toTest);
    }

    protected boolean matchesFrom(@Nonnull Duration toTest) {
        Duration from = (Duration)this.getFrom();
        return from == null || from.isGreaterThanOrEqualTo(toTest) || from.equals(toTest);
    }

    protected boolean matchesTo(@Nonnull Duration toTest) {
        Duration to = (Duration)this.getTo();
        return to == null || to.isLessThan(toTest);
    }

    public static class Adapter
    extends XmlAdapter<Container, DurationRange> {
        public DurationRange unmarshal(Container v) throws Exception {
            DurationRange result;
            if (v != null) {
                Long from = v.getFrom();
                Long to = v.getTo();
                result = new DurationRange(from != null ? new Duration(from) : null, to != null ? new Duration(to) : null);
            } else {
                result = null;
            }
            return result;
        }

        public Container marshal(DurationRange v) throws Exception {
            Container result;
            if (v != null) {
                result = new Container();
                Duration from = (Duration)v.getFrom();
                Duration to = (Duration)v.getTo();
                result.setFrom(from != null ? Long.valueOf(from.in(TimeUnit.MILLISECONDS)) : null);
                result.setTo(to != null ? Long.valueOf(to.in(TimeUnit.MILLISECONDS)) : null);
            } else {
                result = null;
            }
            return result;
        }
    }

    @XmlRootElement(name="durationRange")
    @XmlType(name="durationRangeType")
    public static class Container {
        private Long _from;
        private Long _to;

        @XmlAttribute(name="from")
        public Long getFrom() {
            return this._from;
        }

        public void setFrom(Long from) {
            this._from = from;
        }

        @XmlAttribute(name="to")
        public Long getTo() {
            return this._to;
        }

        public void setTo(Long to) {
            this._to = to;
        }
    }
}

