/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.FilterIterator;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.Hint;
import org.echocat.jomon.runtime.util.Hints;
import org.echocat.jomon.runtime.util.Key;
import org.echocat.jomon.runtime.util.MutableValueProvider;
import org.echocat.jomon.runtime.util.ValueProvider;

public class ExtendingHints
extends Hints {
    protected static final Object NULL = new Object();
    private final Hints _superHints;

    public ExtendingHints(@Nonnull Hints superHints) {
        this._superHints = superHints;
    }

    public ExtendingHints(@Nonnull Hints superHints, @Nullable Map<Hint<?>, Object> hints) {
        super(hints);
        this._superHints = superHints;
    }

    public ExtendingHints(@Nonnull Hints superHints, @Nullable Hints hints) {
        super(hints);
        this._superHints = superHints;
    }

    @Override
    public <T> T get(@Nonnull Key<T> hint, @Nullable T defaultValue) {
        T result = super.get(hint, null);
        if (result == NULL) {
            result = null;
        } else if (result == null) {
            result = ((ValueProvider.Base)this._superHints).get(hint, defaultValue);
        }
        return result != null ? result : (T)defaultValue;
    }

    @Override
    public <T> void remove(@Nonnull Key<T> hint) {
        ((MutableValueProvider.Base)this).set(hint, NULL);
    }

    @Override
    @Deprecated
    public boolean isSet(@Nonnull Hint<?> hint) {
        Object value = this.getKeyToValue().get(hint);
        return value != null && value != NULL || hint.getDefaultValue() != null;
    }

    @Override
    public Iterator<Entry<Key<Object>, Object>> iterator() {
        return new FilterIterator(Iterators.concat(super.iterator(), this._superHints.iterator()), (Predicate)new Predicate<Entry<Key<Object>, Object>>(){

            public boolean evaluate(Entry<Key<Object>, Object> entry) {
                return entry != null && entry.getValue() != NULL;
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof ExtendingHints) || !super.equals(o)) {
            result = false;
        } else {
            ExtendingHints that = (ExtendingHints)o;
            result = this._superHints.equals(that._superHints);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._superHints.hashCode();
        return result;
    }
}

