/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.StringUtils;
import org.echocat.jomon.runtime.util.GlobPattern;

public class Glob {
    private String _patternSource;
    private GlobPattern[] _compiledPattern;
    private final boolean _caseInSensitive;

    public static boolean containsGlob(String pattern) {
        boolean result = false;
        try {
            Glob glob = new Glob(pattern);
            result = glob.containsGlob();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public Glob(String pattern) throws ParseException {
        this(pattern, false);
    }

    public Glob(String pattern, boolean caseInSensitive) throws ParseException {
        this._patternSource = pattern;
        this._caseInSensitive = caseInSensitive;
        this.compilePattern();
    }

    public boolean matches(String string) {
        boolean result;
        String src = string;
        if (this._compiledPattern.length == 1) {
            GlobPattern pattern = this._compiledPattern[0];
            result = pattern.getType() == '*' ? true : (pattern.getType() == '?' ? src.length() == 1 : (this._caseInSensitive ? src.equalsIgnoreCase(pattern.getText()) : src.equals(pattern.getText())));
        } else if (this._compiledPattern.length == 2) {
            GlobPattern pattern1 = this._compiledPattern[0];
            GlobPattern pattern2 = this._compiledPattern[1];
            if (this._caseInSensitive) {
                src = src.toLowerCase();
            }
            result = pattern1.getType() == 't' ? src.startsWith(pattern1.getText()) && (pattern2.getType() == '*' || src.length() == pattern1.getTextLength() + 1) : src.endsWith(pattern2.getText()) && (pattern1.getType() == '*' || src.length() == pattern2.getTextLength() + 1);
        } else {
            result = this.matches(src.toCharArray());
        }
        return result;
    }

    public boolean matches(char[] src) {
        if (this._caseInSensitive) {
            StringUtils.toLowerCase(src);
        }
        return this.matchIntern(src, 0, 0);
    }

    private boolean matchIntern(char[] csrc, int pos, int currentSpos) {
        int spos = currentSpos;
        for (int p = pos; p < this._compiledPattern.length; ++p) {
            GlobPattern pattern = this._compiledPattern[p];
            if (pattern.getType() == 't') {
                if (!StringUtils.startsWith(csrc, pattern.getChars(), spos)) {
                    return false;
                }
                spos += pattern.getTextLength();
                continue;
            }
            if (pattern.getType() == '?') {
                if (spos++ != csrc.length) continue;
                return false;
            }
            if (pattern.getNextTextElement() == null) {
                return true;
            }
            char[] chars = pattern.getNextTextElement().getChars();
            int substrPos = StringUtils.indexOf(csrc, chars, spos);
            while (substrPos != -1) {
                if (p == this._compiledPattern.length - 3) {
                    GlobPattern p2 = this._compiledPattern[this._compiledPattern.length - 1];
                    if (p2.getType() == '*') {
                        return true;
                    }
                    if (p2.getType() == '?' && substrPos + chars.length == csrc.length - 1) {
                        return true;
                    }
                }
                if (p >= this._compiledPattern.length - 2) {
                    return true;
                }
                if (this.matchIntern(csrc, p + 2, substrPos += chars.length)) {
                    return true;
                }
                substrPos = StringUtils.indexOf(csrc, chars, substrPos + 1);
            }
            return false;
        }
        return csrc.length == spos;
    }

    public boolean containsGlob() {
        return this.getCompiledPattern().length != 1 || this.getCompiledPattern()[0].getType() != 't';
    }

    public boolean isCaseInSensitive() {
        return this._caseInSensitive;
    }

    private void compilePattern() throws ParseException {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        ArrayList<GlobPattern> patterns = new ArrayList<GlobPattern>();
        for (int a = 0; a < this._patternSource.length(); ++a) {
            char c = this._patternSource.charAt(a);
            if (c == '\\') {
                if (escaped) {
                    sb.append('\\');
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                if (c != '?' && c != '*') {
                    sb.append("\\");
                    continue;
                }
                sb.append(c);
                escaped = false;
                continue;
            }
            if (c == '*' || c == '?') {
                if (sb.length() > 0) {
                    patterns.add(new GlobPattern('t', sb.toString()));
                    sb = new StringBuilder();
                }
                patterns.add(new GlobPattern(c));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            patterns.add(new GlobPattern('t', sb.toString()));
        }
        this.addMetaInformation(patterns);
        this._compiledPattern = new GlobPattern[patterns.size()];
        patterns.toArray(this._compiledPattern);
    }

    private void addMetaInformation(List<GlobPattern> patterns) {
        block0: for (int a = 0; a < patterns.size(); ++a) {
            GlobPattern p = patterns.get(a);
            if (this._caseInSensitive && p.getType() == 't') {
                p.setText(p.getText().toLowerCase());
            }
            for (int b = a + 1; b < patterns.size(); ++b) {
                GlobPattern p2 = patterns.get(b);
                if (p.getType() == '*' && (p2.getType() == '*' || p2.getType() == '?')) {
                    patterns.remove(b--);
                    continue;
                }
                if (p.getType() == '?' && p2.getType() == '*') {
                    patterns.remove(b--);
                    continue;
                }
                if (p2.getType() != 't') continue;
                p.setNextTextElement(p2);
                continue block0;
            }
        }
    }

    public GlobPattern[] getCompiledPattern() {
        return this._compiledPattern;
    }

    @Nonnull
    public Pattern toPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        for (GlobPattern pattern : this._compiledPattern) {
            char type = pattern.getType();
            if (type == '*') {
                sb.append(".*");
                continue;
            }
            if (type == '?') {
                sb.append(".");
                continue;
            }
            if (type == 't') {
                sb.append(Pattern.quote(pattern.getText()));
                continue;
            }
            throw new IllegalStateException("Don't know how to handle type " + type + ".");
        }
        sb.append("$");
        return Pattern.compile(sb.toString(), this._caseInSensitive ? 2 : 0);
    }

    public String getPatternSource() {
        return this._patternSource;
    }

    public void setPatternSource(String patternSource) throws ParseException {
        this._patternSource = patternSource;
        this.compilePattern();
    }

    public String toString() {
        return this._patternSource;
    }
}

