/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.echocat.jomon.runtime.util.Key;
import org.echocat.jomon.runtime.util.ValueProvider;

public interface MutableValueProvider
extends ValueProvider {
    public <T> void set(@Nonnull Key<T> var1, @Nullable T var2);

    public <T> void remove(@Nonnull Key<T> var1);

    @NotThreadSafe
    public static class Impl
    extends Base {
        @Nonnull
        private final Map<Key<Object>, Object> _keyToValue;

        public Impl() {
            this(new HashMap());
        }

        public Impl(@Nonnull Map<Key<?>, ?> keyToValue) {
            this._keyToValue = keyToValue;
        }

        @Override
        @Nonnull
        protected Map<Key<Object>, Object> getKeyToValue() {
            return this._keyToValue;
        }
    }

    public static abstract class Base
    extends ValueProvider.Base
    implements MutableValueProvider {
        @Override
        public <T> void set(@Nonnull Key<T> key, @Nullable T value) {
            Class<T> valueType = key.getValueType();
            if (value != null && !valueType.isInstance(value)) {
                throw new IllegalArgumentException("The given value is not of type " + key.getValueType().getName() + " which is expected by " + key + ".");
            }
            if (!key.isNullValueAllowed() && value == null) {
                throw new NullPointerException(key + " does not accept null values.");
            }
            this.getKeyToValue().put(key, value);
        }

        @Override
        public <T> void remove(@Nonnull Key<T> key) {
            this.getKeyToValue().remove(key);
        }
    }
}

