/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nullable;

public class ResourceUtils {
    public static void closeQuietlyIfAutoCloseable(@Nullable Object autoCloseable) {
        try {
            if (autoCloseable instanceof AutoCloseable) {
                ((AutoCloseable)autoCloseable).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(@Nullable AutoCloseable autoCloseable) {
        ResourceUtils.closeQuietlyIfAutoCloseable((Object)autoCloseable);
    }

    public static void closeQuietlyIfAutoCloseable(@Nullable Iterable<?> elements) {
        try {
            if (elements != null) {
                for (Object element : elements) {
                    ResourceUtils.closeQuietlyIfAutoCloseable(element);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(@Nullable Iterable<? extends AutoCloseable> elements) {
        ResourceUtils.closeQuietlyIfAutoCloseable(elements);
    }

    public static void closeQuietlyIfAutoCloseable(Object ... elements) {
        try {
            if (elements != null) {
                for (Object element : elements) {
                    ResourceUtils.closeQuietlyIfAutoCloseable(element);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable ... elements) {
        ResourceUtils.closeQuietlyIfAutoCloseable(elements);
    }

    private ResourceUtils() {
    }
}

