/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.echocat.jomon.runtime.jaxb.PatternAdapter;
import org.echocat.jomon.runtime.util.GotInterruptedException;
import org.echocat.jomon.runtime.util.LazyEntry;
import org.echocat.jomon.runtime.util.PostProducing;
import org.echocat.jomon.runtime.util.ProducingType;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.jomon.runtime.util.ValueProducingFailedException;

@XmlTransient
public interface Value<T> {
    public static final Set<Class<? extends Value<?>>> ALL_DEFAULT_VALUE_TYPES = Sets.newHashSet((Object[])new Class[]{BooleanValue.class, ByteValue.class, CharacterValue.class, ShortValue.class, IntegerValue.class, LongValue.class, BigIntegerValue.class, FloatValue.class, DoubleValue.class, BigDecimalValue.class, StringValue.class, DateValue.class, PatternValue.class});

    @Nonnull
    public T getValue();

    @ThreadSafe
    public static class Lazy<K, V>
    extends BaseValueSupport<V> {
        private final K _key;
        private final ValueProducer<K, V> _producer;
        private final ProducingType _producingType;
        private volatile V _value;
        private volatile Exception _producingException;
        private volatile LazyEntry.ValueState _valueState = LazyEntry.ValueState.notProducedYet;

        @Nonnull
        public static <K, V> Value<V> lazyValueFor(@Nullable K key, @Nullable ValueProducer<K, V> producer, @Nonnull ProducingType producingType) {
            return new Lazy<K, V>(key, producer, producingType);
        }

        @Nonnull
        public static <V> Value<V> lazyValueFor(@Nullable Callable<V> producer, @Nonnull ProducingType producingType) {
            return Lazy.lazyValueFor(null, ValueProducer.CallableAdapter.valueProducerFor(producer), producingType);
        }

        @Nonnull
        public static <K, V> Value<V> blockingLazyValueFor(@Nullable K key, @Nullable ValueProducer<K, V> producer) {
            return Lazy.lazyValueFor(key, producer, ProducingType.blocking);
        }

        @Nonnull
        public static <V> Value<V> blockingLazyValueFor(@Nullable Callable<V> producer) {
            return Lazy.lazyValueFor(producer, ProducingType.blocking);
        }

        @Nonnull
        public static <K, V> Value<V> nonBlockingLazyValueFor(@Nullable K key, @Nullable ValueProducer<K, V> producer) {
            return Lazy.lazyValueFor(key, producer, ProducingType.nonBlocking);
        }

        @Nonnull
        public static <V> Value<V> nonblockingLazyValueFor(@Nullable Callable<V> producer) {
            return Lazy.lazyValueFor(producer, ProducingType.nonBlocking);
        }

        public Lazy(@Nullable K key, @Nullable ValueProducer<K, V> producer, @Nonnull ProducingType producingType) {
            this._key = key;
            this._producer = producer;
            this._producingType = producingType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            V result;
            if (this._valueState == LazyEntry.ValueState.produced) {
                result = this._value;
            } else {
                if (this._producingType == ProducingType.blocking) {
                    ValueProducer<K, V> valueProducer = this._producer;
                    synchronized (valueProducer) {
                        if (this._valueState == LazyEntry.ValueState.notProducedYet) {
                            this.callProducer();
                        } else {
                            this.waitWhileProducerIsActive();
                        }
                    }
                } else if (this._producingType == ProducingType.nonBlocking) {
                    this.callProducer();
                } else {
                    throw new IllegalStateException("Could not handle producingType " + (Object)((Object)this._producingType) + ".");
                }
                if (this._valueState == LazyEntry.ValueState.produced) {
                    result = this._value;
                } else {
                    if (this._valueState == LazyEntry.ValueState.producingFailed) {
                        throw new ValueProducingFailedException(this._key, (Throwable)this._producingException);
                    }
                    throw new IllegalStateException("Unexpected _valueState: " + (Object)((Object)this._valueState));
                }
            }
            return result;
        }

        @Nullable
        public V getWithoutProducing() {
            return this._value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="_producer")
        private void callProducer() {
            this._valueState = LazyEntry.ValueState.producing;
            try {
                this._value = this._producer.produce(this._key);
                this._valueState = LazyEntry.ValueState.produced;
            }
            catch (Exception e) {
                this._producingException = e;
                this._valueState = LazyEntry.ValueState.producingFailed;
            }
            finally {
                try {
                    if (this._valueState == LazyEntry.ValueState.producing) {
                        this._valueState = LazyEntry.ValueState.producingFailed;
                    }
                }
                finally {
                    try {
                        if (this._producingType == ProducingType.blocking) {
                            this._producer.notifyAll();
                        }
                    }
                    finally {
                        if (this._valueState == LazyEntry.ValueState.produced && this._producer instanceof PostProducing) {
                            try {
                                ((PostProducing)((Object)this._producer)).postProducing(this._key, this._value);
                            }
                            catch (Exception e) {
                                this._producingException = e;
                                this._valueState = LazyEntry.ValueState.producingFailed;
                            }
                        }
                    }
                }
            }
        }

        @GuardedBy(value="_producer")
        private void waitWhileProducerIsActive() {
            if (this._producingType != ProducingType.blocking) {
                throw new IllegalStateException("This method could only be used if producingType is " + (Object)((Object)ProducingType.blocking) + ".");
            }
            while (this._valueState == LazyEntry.ValueState.producing) {
                try {
                    this._producer.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new GotInterruptedException("Got interrupted while waiting for production of cache value for key " + this._key + ".", e);
                }
            }
        }
    }

    @ThreadSafe
    public static class Fixed<V>
    extends BaseValueSupport<V> {
        private final V _value;

        @Nullable
        public static <V> Fixed<V> fixed(@Nullable V value) {
            return value != null ? new Fixed<V>(value) : null;
        }

        public Fixed(V value) {
            this._value = value;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public String toString() {
            V value = this.getValue();
            return value != null ? value.toString() : "null";
        }

        @Override
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Value)) {
                result = false;
            } else {
                Value that = (Value)o;
                V value = this.getValue();
                result = value != null ? value.equals(that.getValue()) : that.getValue() == null;
            }
            return result;
        }

        @Override
        public int hashCode() {
            V value = this.getValue();
            return value != null ? value.hashCode() : 0;
        }
    }

    @XmlTransient
    public static abstract class ValueSupport<T>
    extends BaseValueSupport<T> {
        private T _content;

        @Override
        @Nullable
        @XmlAttribute(name="content")
        public T getValue() {
            return this._content;
        }

        public void setValue(T content) {
            this._content = content;
        }

        @Override
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Value)) {
                result = false;
            } else {
                Value that = (Value)o;
                T content = this.getValue();
                result = content != null ? content.equals(that.getValue()) : that.getValue() == null;
            }
            return result;
        }

        @Override
        public int hashCode() {
            T content = this.getValue();
            return content != null ? content.hashCode() : 0;
        }

        @Override
        public String toString() {
            T content = this.getValue();
            return content != null ? content.toString() : "null";
        }
    }

    @XmlTransient
    public static abstract class BaseValueSupport<T>
    implements Value<T> {
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof Value)) {
                result = false;
            } else {
                Value that = (Value)o;
                Object content = this.getValue();
                result = content != null ? content.equals(that.getValue()) : that.getValue() == null;
            }
            return result;
        }

        public int hashCode() {
            Object content = this.getValue();
            return content != null ? content.hashCode() : 0;
        }

        public String toString() {
            Object content = this.getValue();
            return content != null ? content.toString() : "null";
        }
    }

    @XmlType(name="patternType")
    @XmlRootElement(name="pattern")
    public static class PatternValue
    extends ValueSupport<Pattern> {
        @Override
        @XmlAttribute(name="content")
        @XmlJavaTypeAdapter(value=PatternAdapter.class)
        public Pattern getValue() {
            return (Pattern)super.getValue();
        }

        @Override
        public void setValue(Pattern content) {
            super.setValue(content);
        }
    }

    @XmlType(name="dateType")
    @XmlRootElement(name="date")
    public static class DateValue
    extends ValueSupport<Date> {
        @Override
        @XmlAttribute(name="content")
        public Date getValue() {
            return (Date)super.getValue();
        }

        @Override
        public void setValue(Date content) {
            super.setValue(content);
        }
    }

    @XmlType(name="stringType")
    @XmlRootElement(name="string")
    public static class StringValue
    extends ValueSupport<String> {
        @Override
        @XmlAttribute(name="content")
        public String getValue() {
            return (String)super.getValue();
        }

        @Override
        public void setValue(String content) {
            super.setValue(content);
        }
    }

    @XmlType(name="bigDecimalType")
    @XmlRootElement(name="bigDecimal")
    public static class BigDecimalValue
    extends ValueSupport<BigDecimal> {
        @Override
        @XmlAttribute(name="content")
        public BigDecimal getValue() {
            return (BigDecimal)super.getValue();
        }

        @Override
        public void setValue(BigDecimal content) {
            super.setValue(content);
        }
    }

    @XmlType(name="doubleType")
    @XmlRootElement(name="double")
    public static class DoubleValue
    extends ValueSupport<Double> {
        @Override
        @XmlAttribute(name="content")
        public Double getValue() {
            return (Double)super.getValue();
        }

        @Override
        public void setValue(Double content) {
            super.setValue(content);
        }
    }

    @XmlType(name="floatType")
    @XmlRootElement(name="float")
    public static class FloatValue
    extends ValueSupport<Float> {
        @Override
        @XmlAttribute(name="content")
        public Float getValue() {
            return (Float)super.getValue();
        }

        @Override
        public void setValue(Float content) {
            super.setValue(content);
        }
    }

    @XmlType(name="bigIntegerType")
    @XmlRootElement(name="bigInteger")
    public static class BigIntegerValue
    extends ValueSupport<BigInteger> {
        @Override
        @XmlAttribute(name="content")
        public BigInteger getValue() {
            return (BigInteger)super.getValue();
        }

        @Override
        public void setValue(BigInteger content) {
            super.setValue(content);
        }
    }

    @XmlType(name="longType")
    @XmlRootElement(name="long")
    public static class LongValue
    extends ValueSupport<Long> {
        @Override
        @XmlAttribute(name="content")
        public Long getValue() {
            return (Long)super.getValue();
        }

        @Override
        public void setValue(Long content) {
            super.setValue(content);
        }
    }

    @XmlType(name="integerType")
    @XmlRootElement(name="integer")
    public static class IntegerValue
    extends ValueSupport<Integer> {
        @Override
        @XmlAttribute(name="content")
        public Integer getValue() {
            return (Integer)super.getValue();
        }

        @Override
        public void setValue(Integer content) {
            super.setValue(content);
        }
    }

    @XmlType(name="shortType")
    @XmlRootElement(name="short")
    public static class ShortValue
    extends ValueSupport<Short> {
        @Override
        @XmlAttribute(name="content")
        public Short getValue() {
            return (Short)super.getValue();
        }

        @Override
        public void setValue(Short content) {
            super.setValue(content);
        }
    }

    @XmlType(name="characterType")
    @XmlRootElement(name="character")
    public static class CharacterValue
    extends ValueSupport<Character> {
        @Override
        @XmlAttribute(name="content")
        public Character getValue() {
            return (Character)super.getValue();
        }

        @Override
        public void setValue(Character content) {
            super.setValue(content);
        }
    }

    @XmlType(name="byteType")
    @XmlRootElement(name="byte")
    public static class ByteValue
    extends ValueSupport<Byte> {
        @Override
        @XmlAttribute(name="content")
        public Byte getValue() {
            return (Byte)super.getValue();
        }

        @Override
        public void setValue(Byte content) {
            super.setValue(content);
        }
    }

    @XmlType(name="booleanType")
    @XmlRootElement(name="boolean")
    public static class BooleanValue
    extends ValueSupport<Boolean> {
        @Override
        @XmlAttribute(name="content")
        public Boolean getValue() {
            return (Boolean)super.getValue();
        }

        @Override
        public void setValue(Boolean content) {
            super.setValue(content);
        }
    }

    public static class Values {
        private Values() {
        }

        @Nullable
        public static <T> Value<T> valueOf(@Nullable T value) {
            ValueSupport result;
            if (value != null) {
                if (value instanceof Boolean) {
                    result = new BooleanValue();
                } else if (value instanceof Byte) {
                    result = new ByteValue();
                } else if (value instanceof Character) {
                    result = new CharacterValue();
                } else if (value instanceof Short) {
                    result = new ShortValue();
                } else if (value instanceof Integer) {
                    result = new IntegerValue();
                } else if (value instanceof Long) {
                    result = new LongValue();
                } else if (value instanceof BigInteger) {
                    result = new BigIntegerValue();
                } else if (value instanceof Float) {
                    result = new FloatValue();
                } else if (value instanceof Double) {
                    result = new DoubleValue();
                } else if (value instanceof BigDecimal) {
                    result = new BigDecimalValue();
                } else if (value instanceof String) {
                    result = new StringValue();
                } else if (value instanceof Date) {
                    result = new DateValue();
                } else if (value instanceof Pattern) {
                    result = new PatternValue();
                } else {
                    throw new IllegalArgumentException("Don't know how to handle: " + value);
                }
                ((ValueSupport)result).setValue(value);
            } else {
                result = null;
            }
            return result;
        }
    }
}

