/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.Key;

public interface ValueProvider
extends Iterable<Entry<Key<Object>, Object>> {
    public boolean contains(@Nonnull Key<?> var1);

    @Nullable
    public <T> T get(@Nonnull Key<T> var1);

    @Nullable
    public <T> T get(@Nonnull Key<T> var1, @Nullable T var2);

    public Map<Key<Object>, Object> toMap();

    @ThreadSafe
    @Immutable
    public static class Impl
    extends Base {
        @Nonnull
        private final Map<Key<Object>, Object> _keyToValue;

        public Impl(@Nonnull Map<Key<?>, ?> keyToValue) {
            this._keyToValue = keyToValue;
        }

        @Override
        @Nonnull
        protected Map<Key<Object>, Object> getKeyToValue() {
            return this._keyToValue;
        }
    }

    public static abstract class Support
    implements ValueProvider {
        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof ValueProvider)) {
                result = false;
            } else {
                result = true;
                ValueProvider that = (ValueProvider)o;
                long numberOfKeys = 0L;
                for (Entry keyAndValue : this) {
                    Key key = (Key)keyAndValue.getKey();
                    Object value = keyAndValue.getValue();
                    Object thatValue = that.get(key, null);
                    boolean bl = value != null ? value.equals(thatValue) : (result = thatValue == null);
                    if (!result) break;
                    ++numberOfKeys;
                }
                if (result) {
                    long numberOfThatKeys = CollectionUtils.countElementsOf(that.iterator());
                    result = numberOfKeys == numberOfThatKeys;
                }
            }
            return result;
        }

        public int hashCode() {
            int result = 0;
            for (Entry keyAndValue : this) {
                Key key = (Key)keyAndValue.getKey();
                Object value = keyAndValue.getValue();
                result = 31 * result + (key != null ? key.getName().hashCode() : 0);
                result = 31 * result + (value != null ? value.hashCode() : 0);
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            boolean first = true;
            for (Entry keyAndValue : this) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(keyAndValue.getKey()).append("=").append(keyAndValue.getValue());
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public static abstract class Base
    extends Support {
        @Override
        public boolean contains(@Nonnull Key<?> key) {
            return this.getKeyToValue().get(key) != null || key.getDefaultValue() != null;
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key) {
            return this.get(key, key.getDefaultValue());
        }

        @Override
        @Nullable
        public <T> T get(@Nonnull Key<T> key, @Nullable T defaultValue) {
            Object plainValue;
            Class<T> valueType = key.getValueType();
            T value = valueType.cast(plainValue = this.getKeyToValue().get(key));
            return value != null ? value : defaultValue;
        }

        @Override
        public Iterator<Entry<Key<Object>, Object>> iterator() {
            return new ConvertingIterator<Map.Entry<Key<Object>, Object>, Entry<Key<Object>, Object>>(this.getKeyToValue().entrySet().iterator()){

                @Override
                protected Entry<Key<Object>, Object> convert(Map.Entry<Key<Object>, Object> input) {
                    return new Entry.Impl<Key<Object>, Object>(input.getKey(), input.getValue());
                }
            };
        }

        @Override
        public Map<Key<Object>, Object> toMap() {
            return new HashMap<Key<Object>, Object>(this.getKeyToValue());
        }

        @Nonnull
        protected abstract Map<Key<Object>, Object> getKeyToValue();
    }
}

