/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.codec.DefaultSha512;
import org.echocat.jomon.runtime.codec.HashFunctionUtils;
import org.echocat.jomon.runtime.codec.Sha512;

public class Sha512Utils {
    protected static final Constructor<? extends Sha512> DEFAULT_CONSTRUCTOR = HashFunctionUtils.selectConstructorFor(Sha512.class, DefaultSha512.class);

    @Nonnull
    public static Sha512 sha512() {
        return HashFunctionUtils.newInstanceOf(DEFAULT_CONSTRUCTOR);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable String with) {
        return Sha512Utils.sha512().update(with);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable String with, @Nonnull Charset charset) {
        return Sha512Utils.sha512().update(with, charset);
    }

    @Nonnull
    public static Sha512 sha512Of(byte with) {
        return Sha512Utils.sha512().update(with);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable byte[] with) {
        return Sha512Utils.sha512().update(with);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable byte[] with, @Nonnegative int offset, @Nonnegative int length) {
        return Sha512Utils.sha512().update(with, offset, length);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable @WillNotClose InputStream is) throws IOException {
        return Sha512Utils.sha512().update(is);
    }

    @Nonnull
    public static Sha512 sha512Of(@Nullable File file) throws IOException {
        return Sha512Utils.sha512().update(file);
    }

    private Sha512Utils() {
    }
}

