/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.GotInterruptedException;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    public static void stop(@Nullable Thread thread) {
        if (thread != null) {
            ResourceUtils.closeQuietlyIfAutoCloseable((Object)thread);
            thread.interrupt();
            try {
                while (thread.isAlive()) {
                    thread.join(TimeUnit.SECONDS.toMillis(10L));
                    if (!thread.isAlive()) continue;
                    Throwable throwable = new Throwable();
                    throwable.setStackTrace(thread.getStackTrace());
                    LOG.info("Still wait for termination of '" + thread.getName() + "'...", throwable);
                    thread.interrupt();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                LOG.debug("Could not wait for termination of '" + thread.getName() + "' - but this thread was interrupted.");
            }
        }
    }

    public static void stop(@Nullable Iterable<? extends Thread> threads) {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.stop(thread);
            }
        }
    }

    public static void stop(Thread ... threads) {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.stop(thread);
            }
        }
    }

    public static void join(@Nullable Duration maximumWaitTime, @Nullable Thread thread) throws InterruptedException {
        if (thread != null) {
            if (maximumWaitTime != null) {
                thread.join(maximumWaitTime.in(TimeUnit.MILLISECONDS));
            } else {
                thread.join();
            }
        }
    }

    public static void join(@Nullable Duration maximumWaitTime, @Nullable Iterable<? extends Thread> threads) throws InterruptedException {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.join(maximumWaitTime, thread);
            }
        }
    }

    public static void join(@Nullable Duration maximumWaitTime, Thread ... threads) throws InterruptedException {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.join(maximumWaitTime, thread);
            }
        }
    }

    public static void join(@Nullable Thread thread) throws InterruptedException {
        ThreadUtils.join(null, thread);
    }

    public static void join(@Nullable Iterable<? extends Thread> threads) throws InterruptedException {
        ThreadUtils.join(null, threads);
    }

    public static void join(Thread ... threads) throws InterruptedException {
        ThreadUtils.join(null, threads);
    }

    public static void joinSafe(@Nullable Duration maximumWaitTime, @Nullable Thread thread) throws GotInterruptedException {
        try {
            ThreadUtils.join(maximumWaitTime, thread);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GotInterruptedException("Got interrupted while waiting for thread " + thread + ".", e);
        }
    }

    public static void joinSafe(@Nullable Duration maximumWaitTime, @Nullable Iterable<? extends Thread> threads) throws GotInterruptedException {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.joinSafe(maximumWaitTime, thread);
            }
        }
    }

    public static void joinSafe(@Nullable Duration maximumWaitTime, Thread ... threads) throws GotInterruptedException {
        if (threads != null) {
            for (Thread thread : threads) {
                ThreadUtils.joinSafe(maximumWaitTime, thread);
            }
        }
    }

    public static void joinSafe(@Nullable Thread thread) throws GotInterruptedException {
        ThreadUtils.joinSafe(null, thread);
    }

    public static void joinSafe(@Nullable Iterable<? extends Thread> threads) throws GotInterruptedException {
        ThreadUtils.joinSafe(null, threads);
    }

    public static void joinSafe(Thread ... threads) throws GotInterruptedException {
        ThreadUtils.joinSafe(null, threads);
    }

    private ThreadUtils() {
    }
}

