/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.date;

import com.google.common.base.Predicate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class CalendarDate
implements Predicate<CalendarDate> {
    private static final Pattern PATTERN_PARSER = Pattern.compile("((?:-?\\d{1,4}|\\?+|\\*))(?:|-(\\d{1,2}|\\?+|\\*)(?:|-(\\d{1,2}|\\?+|\\*)))");
    private final Integer _year;
    private final Integer _month;
    private final Integer _day;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarDate(@Nullable String string) throws IllegalArgumentException {
        if (string != null && !string.trim().isEmpty()) {
            Matcher matcher = PATTERN_PARSER.matcher(string);
            if (!matcher.matches()) throw new IllegalArgumentException("Invalid pattern: " + string);
            this._year = CalendarDate.parsePart(string, matcher.group(1), "year");
            this._month = CalendarDate.validateMonth(CalendarDate.parsePart(string, matcher.group(2), "month"));
            this._day = CalendarDate.validateDay(CalendarDate.parsePart(string, matcher.group(3), "day"));
            return;
        } else {
            this._year = null;
            this._month = null;
            this._day = null;
        }
    }

    public CalendarDate(@Nullable Date date) throws IllegalArgumentException {
        this(CalendarDate.calendarFromDate(date));
    }

    public CalendarDate(@Nullable Calendar calendar) throws IllegalArgumentException {
        this(calendar != null ? Integer.valueOf(calendar.get(1)) : null, calendar != null ? Integer.valueOf(calendar.get(2) + 1) : null, calendar != null ? Integer.valueOf(calendar.get(5)) : null);
    }

    public CalendarDate(@Nullable Integer year, @Nullable Integer month, @Nullable Integer day) throws IllegalArgumentException {
        this._year = year;
        this._month = CalendarDate.validateMonth(month);
        this._day = CalendarDate.validateDay(day);
    }

    @Nullable
    public Integer getYear() {
        return this._year;
    }

    @Nullable
    public Integer getMonth() {
        return this._month;
    }

    @Nullable
    public Integer getDay() {
        return this._day;
    }

    public boolean hasYear() {
        return this._year != null;
    }

    public boolean hasMonth() {
        return this._month != null;
    }

    public boolean hasDay() {
        return this._day != null;
    }

    public boolean hasValue() {
        return this.hasYear() || this.hasMonth() || this.hasDay();
    }

    @Nonnull
    public Calendar toCalendar(@Nonnull Calendar base) {
        if (this._year != null) {
            base.set(1, this._year);
        }
        if (this._month != null) {
            base.set(2, this._month - 1);
        }
        if (this._day != null) {
            base.set(5, this._day);
        }
        return base;
    }

    @Nonnull
    public Date toDate(@Nonnull Date base) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(base);
        return this.toCalendar(calendar).getTime();
    }

    @Nonnull
    public CalendarDate asMonthAndDayOnly() {
        return new CalendarDate(null, this._month, this._day);
    }

    @Nonnull
    public CalendarDate asDayOnly() {
        return new CalendarDate(null, null, this._day);
    }

    @Nonnull
    public CalendarDate asMonthOnly() {
        return new CalendarDate(null, this._month, null);
    }

    @Nonnull
    public CalendarDate asYearOnly() {
        return new CalendarDate(this._year, null, null);
    }

    public boolean apply(@Nullable CalendarDate input) {
        boolean result = input != null ? !(this._year != null && !this._year.equals(input.getYear()) || this._month != null && !this._month.equals(input.getMonth()) || this._day != null && !this._day.equals(input.getDay())) : this._year == null && this._month == null && this._day == null;
        return result;
    }

    public boolean matches(@Nullable CalendarDate input) {
        return this.apply(input);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof CalendarDate)) {
            result = false;
        } else {
            CalendarDate that = (CalendarDate)o;
            result = (this._day != null ? this._day.equals(that.getDay()) : that.getDay() == null) && (this._month != null ? this._month.equals(that.getMonth()) : that.getMonth() == null) && (this._year != null ? this._year.equals(that.getYear()) : that.getYear() == null);
        }
        return result;
    }

    public int hashCode() {
        int result = this._year != null ? this._year.hashCode() : 0;
        result = 31 * result + (this._month != null ? this._month.hashCode() : 0);
        result = 31 * result + (this._day != null ? this._day.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._year != null ? String.format("%04d", this._year) : "????");
        sb.append('-').append(this._month != null ? String.format("%02d", this._month) : "??");
        sb.append('-').append(this._day != null ? String.format("%02d", this._day) : "??");
        return sb.toString();
    }

    @Nonnull
    public Pattern toPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append('^');
        sb.append(this._year != null ? String.format("%04d", this._year) : "[\\d?*]+");
        sb.append('-').append(this._month != null ? String.format("%02d", this._month) : "[\\d?*]+");
        sb.append('-').append(this._day != null ? String.format("%02d", this._day) : "[\\d?*]+");
        sb.append('$');
        return Pattern.compile(sb.toString(), 8);
    }

    @Nullable
    protected static Calendar calendarFromDate(@Nullable Date date) {
        GregorianCalendar calendar;
        if (date != null) {
            calendar = new GregorianCalendar();
            calendar.setTime(date);
        } else {
            calendar = null;
        }
        return calendar;
    }

    @Nullable
    protected static Integer parsePart(@Nonnull String string, @Nonnull String plain, @Nonnull String name) throws IllegalArgumentException {
        Integer result;
        if (plain == null || plain.startsWith("?") || plain.equals("*")) {
            result = null;
        } else {
            try {
                result = Integer.parseInt(plain);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse " + name + " of pattern: " + string, e);
            }
        }
        return result;
    }

    @Nullable
    protected static Integer validateMonth(@Nullable Integer month) throws IllegalArgumentException {
        if (month != null && (month < 1 || month > 12)) {
            throw new IllegalArgumentException("Month " + month + " is not valid.");
        }
        return month;
    }

    @Nullable
    protected static Integer validateDay(@Nullable Integer day) throws IllegalArgumentException {
        if (day != null && (day < 1 || day > 31)) {
            throw new IllegalArgumentException("Day " + day + " is not valid.");
        }
        return day;
    }

    public static class Adapter
    extends XmlAdapter<String, CalendarDate> {
        public CalendarDate unmarshal(String v) throws Exception {
            return v != null ? new CalendarDate(v) : null;
        }

        public String marshal(CalendarDate v) throws Exception {
            return v != null ? v.toString() : null;
        }
    }
}

