/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.jaxb;

import java.beans.PropertyEditorSupport;
import java.net.InetSocketAddress;

public class InetSocketAddressPropertyEditor
extends PropertyEditorSupport {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        InetSocketAddress address;
        if (text != null) {
            String trimmedText = text.trim();
            if (!trimmedText.isEmpty()) {
                int port;
                int lastDoubleDot = trimmedText.lastIndexOf(58);
                if (lastDoubleDot <= 0 || lastDoubleDot + 1 >= trimmedText.length()) throw new IllegalArgumentException("Port missing");
                String host = trimmedText.substring(0, lastDoubleDot).trim();
                String plainPort = trimmedText.substring(lastDoubleDot + 1).trim();
                try {
                    port = Integer.parseInt(plainPort);
                }
                catch (NumberFormatException ignored) {
                    throw new IllegalArgumentException("Illegal port: " + plainPort);
                }
                address = new InetSocketAddress(host, port);
            } else {
                address = null;
            }
        } else {
            address = null;
        }
        this.setValue(address);
    }
}

