/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.jaxb;

import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class LocaleAdapter
extends XmlAdapter<String, Locale> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locale unmarshal(String v) throws Exception {
        if (v == null) return null;
        String[] localeParts = StringUtils.split((String)v, (char)'_');
        if (localeParts.length == 3) {
            return new Locale(localeParts[0], localeParts[1], localeParts[2]);
        }
        if (localeParts.length == 2) {
            return new Locale(localeParts[0], localeParts[1]);
        }
        if (localeParts.length != 1) throw new IllegalArgumentException("There are too many locale parts provided: " + v);
        return new Locale(localeParts[0]);
    }

    public String marshal(Locale v) throws Exception {
        return v != null ? v.toString() : null;
    }
}

