/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JUtils {
    public static void configureRuntime(@Nullable URL defaultXmlConfigUrl) {
        URL xmlConfigUrl = Log4JUtils.resolveXmlConfigUrl(defaultXmlConfigUrl);
        InputStream is = Log4JUtils.openConfig(xmlConfigUrl);
        try {
            Log4JUtils.configureRuntime(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not configureRuntime log4j with " + xmlConfigUrl + ".", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static void configureRuntime(@Nonnull InputStream log4jXmlConfigAsStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(log4jXmlConfigAsStream);
        try {
            Log4JUtils.configureRuntime(reader);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static void configureRuntime(@Nonnull Reader log4jXmlConfigAsReader) throws IOException {
        Log4JUtils.configure(log4jXmlConfigAsReader, LogManager.getLoggerRepository());
    }

    public static void configure(@Nonnull Reader log4jXmlConfigAsReader, @Nonnull LoggerRepository on) throws IOException {
        DOMConfigurator domConfigurator = new DOMConfigurator();
        domConfigurator.doConfigure(log4jXmlConfigAsReader, on);
    }

    @Nonnull
    private static URL resolveXmlConfigUrl(@Nullable URL defaultXmlConfigUrl) {
        String plainConfigUrl = System.getProperty("log4j.configuration", defaultXmlConfigUrl != null ? defaultXmlConfigUrl.toExternalForm() : null);
        if (plainConfigUrl == null) {
            throw new IllegalArgumentException("The system property 'log4j.configuration' is not set.");
        }
        try {
            return new URL(plainConfigUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The given xmlConfig '" + plainConfigUrl + "' is no valid url.", e);
        }
    }

    @Nonnull
    private static InputStream openConfig(@Nonnull URL xmlConfigUrl) {
        InputStream is;
        try {
            is = xmlConfigUrl.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not open xmlConfig '" + xmlConfigUrl + "'.", e);
        }
        return is;
    }
}

