/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.generation.Requirement;
import org.echocat.jomon.runtime.util.ResourceUtils;

public interface LoggingEnvironmentConfiguration
extends Requirement {
    public static final Charset CHARSET = Charset.forName(System.getProperty(LoggingEnvironmentConfiguration.class.getName() + ".charset", "UTF-8"));

    @Nonnull
    public String getSourceName();

    public boolean isInstallSl4jRequired();

    public static abstract class ForFileSupport<T extends ForFileSupport<T>>
    extends Support<T> {
        @Nonnull
        private final File _file;

        public ForFileSupport(@Nonnull File file) {
            this._file = file;
        }

        @Override
        @Nonnull
        public InputStream openAsInputStream() throws IOException, IllegalArgumentException {
            try {
                return new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("File '" + this._file + "' does not exist.", e);
            }
        }

        @Override
        @Nonnull
        public String getSourceName() {
            return this._file.getPath();
        }

        public String toString() {
            return "Logging configuration '" + this._file + "'";
        }
    }

    public static abstract class ForClassLoaderSupport<T extends ForClassLoaderSupport<T>>
    extends Support<T> {
        @Nonnull
        private final ClassLoader _forLoader;
        @Nonnull
        private final String _configurationFileName;

        public ForClassLoaderSupport(@Nonnull ClassLoader forLoader, @Nonnull String configurationFileName) {
            this._forLoader = forLoader;
            this._configurationFileName = configurationFileName;
        }

        @Override
        @Nonnull
        public InputStream openAsInputStream() throws IOException, IllegalArgumentException {
            InputStream result = this._forLoader.getResourceAsStream(this._configurationFileName);
            if (result == null) {
                throw new IllegalArgumentException("File '" + this._configurationFileName + "' does not exist in classLoader '" + this._forLoader + "'.");
            }
            return result;
        }

        @Override
        @Nonnull
        public String getSourceName() {
            return this._configurationFileName;
        }

        public String toString() {
            return "Logging configuration '" + this._configurationFileName + "' for classLoader '" + this._forLoader + "'";
        }
    }

    public static abstract class ForClassSupport<T extends ForClassSupport<T>>
    extends Support<T> {
        @Nonnull
        private final Class<?> _forClass;
        @Nonnull
        private final String _configurationFileName;

        public ForClassSupport(@Nonnull Class<?> forClass, @Nonnull String configurationFileName) {
            this._forClass = forClass;
            this._configurationFileName = configurationFileName;
        }

        @Override
        @Nonnull
        public InputStream openAsInputStream() throws IOException, IllegalArgumentException {
            InputStream result = this._forClass.getResourceAsStream(this._configurationFileName);
            if (result == null) {
                throw new IllegalArgumentException("File '" + this._configurationFileName + "' does not exist in relation to class '" + this._forClass.getName() + "'.");
            }
            return result;
        }

        @Override
        @Nonnull
        public String getSourceName() {
            return this._configurationFileName;
        }

        public String toString() {
            return "Logging configuration '" + this._configurationFileName + "' for class '" + this._forClass.getName() + "'";
        }
    }

    public static abstract class Support<T extends Support<T>>
    implements LoggingEnvironmentConfiguration {
        private boolean _installSl4jRequired = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Reader openAsReader() throws IOException, IllegalArgumentException {
            boolean success = false;
            InputStream is = this.openAsInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(is, CHARSET);
                success = true;
                InputStreamReader inputStreamReader = reader;
                return inputStreamReader;
            }
            finally {
                if (!success) {
                    ResourceUtils.closeQuietly((AutoCloseable)is);
                }
            }
        }

        @Nullable
        public abstract InputStream openAsInputStream() throws IOException, IllegalArgumentException;

        @Override
        public boolean isInstallSl4jRequired() {
            return this._installSl4jRequired;
        }

        public void setInstallSl4jRequired(boolean installSl4jRequired) {
            this._installSl4jRequired = installSl4jRequired;
        }

        @Nonnull
        public T whichInstallSl4j(boolean installSl4j) {
            this.setInstallSl4jRequired(installSl4j);
            return this.thisObject();
        }

        @Nonnull
        public T whichInstallSl4j() {
            return this.whichInstallSl4j(true);
        }

        @Nonnull
        public T whichNotInstallSl4j() {
            return this.whichInstallSl4j(false);
        }

        @Nonnull
        protected T thisObject() {
            return (T)this;
        }
    }
}

