/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.concurrent.GuardedBy;
import org.echocat.jomon.runtime.util.Entry;
import org.echocat.jomon.runtime.util.GotInterruptedException;
import org.echocat.jomon.runtime.util.PostProducing;
import org.echocat.jomon.runtime.util.ValueProducer;
import org.echocat.jomon.runtime.util.ValueProducingFailedException;
import org.echocat.jomon.runtime.util.WritableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyEntry<K, V>
extends Entry.BaseImpl<K, V>
implements WritableEntry<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyEntry.class);
    private final ValueProducer<K, V> _producer;
    private volatile V _value;
    private volatile Exception _producingException;
    private volatile ValueState _valueState = ValueState.notProducedYet;

    public LazyEntry(K key, ValueProducer<K, V> producer) {
        super(key);
        this._producer = producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        V result;
        if (this._valueState == ValueState.produced) {
            result = this._value;
        } else {
            ValueProducer<K, V> valueProducer = this._producer;
            synchronized (valueProducer) {
                this.waitWhileProducerIsActive();
                if (this._valueState == ValueState.notProducedYet) {
                    this.callProducer();
                }
            }
            if (this._valueState == ValueState.produced) {
                result = this._value;
            } else {
                if (this._valueState == ValueState.producingFailed) {
                    throw new ValueProducingFailedException(this.getKey(), (Throwable)this._producingException);
                }
                throw new IllegalStateException("Unexpected valueState: " + (Object)((Object)this._valueState));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(V value) {
        ValueProducer<K, V> valueProducer = this._producer;
        synchronized (valueProducer) {
            this.waitWhileProducerIsActive();
            this._value = value;
            this._valueState = ValueState.produced;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="_producer")
    protected void callProducer() {
        this._valueState = ValueState.producing;
        try {
            this._value = this._producer.produce(this.getKey());
            this._valueState = ValueState.produced;
        }
        catch (Exception e) {
            this._producingException = e;
            this._valueState = ValueState.producingFailed;
        }
        finally {
            try {
                if (this._valueState == ValueState.producing) {
                    this._valueState = ValueState.producingFailed;
                }
            }
            finally {
                try {
                    if (this._valueState == ValueState.produced && this._producer instanceof PostProducing) {
                        try {
                            ((PostProducing)((Object)this._producer)).postProducing(this.getKey(), this._value);
                        }
                        catch (Exception e) {
                            this._producingException = e;
                            this._valueState = ValueState.producingFailed;
                        }
                    }
                }
                finally {
                    this._producer.notifyAll();
                }
            }
        }
    }

    @GuardedBy(value="_producer")
    protected void waitWhileProducerIsActive() {
        while (this._valueState == ValueState.producing) {
            try {
                this._producer.wait(10000L);
                if (this._valueState != ValueState.producing) continue;
                LOG.warn("Still waiting for valueProducer " + this._producer + " to produce value for key " + this.getKey() + "...");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new GotInterruptedException("Got interrupted while waiting for production of cache value for key " + this.getKey() + ".", e);
            }
        }
    }

    public static enum ValueState {
        notProducedYet,
        producing,
        produced,
        producingFailed;

    }
}

