/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.testing.environments;

import javax.annotation.Nonnull;
import org.echocat.jomon.testing.environments.BaseEnvironment;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BeanEnvironment
extends BaseEnvironment {
    private final ConfigurableApplicationContext _applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanEnvironment(@Nonnull Object bean) {
        String configuration = this.findFileFor(bean.getClass(), this.getConfigurationFileNameSuffixOfClasses(), this.getConfigurationFileNameInPackage());
        if (configuration == null) {
            throw new IllegalStateException("Could not find any configuration for " + bean + ".");
        }
        boolean success = false;
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(configuration);
        try {
            this.autowire((ConfigurableApplicationContext)applicationContext, bean);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    applicationContext.close();
                }
                catch (Exception ignored) {}
            }
        }
        this._applicationContext = applicationContext;
    }

    protected void autowire(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull Object bean) {
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        autowireCapableBeanFactory.autowireBean(bean);
    }

    public void autowire(@Nonnull Object bean) {
        this.autowire(this.getApplicationContext(), bean);
    }

    @Nonnull
    public ConfigurableApplicationContext getApplicationContext() {
        ConfigurableApplicationContext applicationContext = this._applicationContext;
        if (applicationContext == null) {
            throw new IllegalStateException("The initFor method was not yet called.");
        }
        return applicationContext;
    }

    public void close() {
        ConfigurableApplicationContext applicationContext = this._applicationContext;
        if (applicationContext != null) {
            applicationContext.close();
        }
    }

    @Nonnull
    protected String getConfigurationFileNameSuffixOfClasses() {
        return ".beans.testing.xml";
    }

    @Nonnull
    protected String getConfigurationFileNameInPackage() {
        return "beans.testing.xml";
    }
}

