/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class IteratorMatchers {
    @Nonnull
    public static Matcher<Iterator<?>> returnsNothing() {
        return new TypeSafeMatcher<Iterator<?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean matchesSafely(Iterator<?> iterator) {
                try {
                    boolean bl = iterator != null && !iterator.hasNext();
                    return bl;
                }
                finally {
                    ResourceUtils.closeQuietlyIfAutoCloseable(iterator);
                }
            }

            public void describeTo(Description description) {
                description.appendText("returns nothing");
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> returnsItems(T ... expectedItems) {
        return IteratorMatchers.returnsItems(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterator<T>> returnsItems(final @Nonnull Iterable<T> expectedItems) {
        return new TypeSafeMatcher<Iterator<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean matchesSafely(Iterator<T> itemsIterator) {
                try {
                    boolean result;
                    if (itemsIterator != null) {
                        result = true;
                        Iterator expectedItemsIterator = expectedItems.iterator();
                        while (expectedItemsIterator.hasNext() && itemsIterator.hasNext() && result) {
                            Object expectedItem = expectedItemsIterator.next();
                            Object item = itemsIterator.next();
                            result = expectedItem != null ? expectedItem.equals(item) : item == null;
                        }
                        if (result) {
                            result = !expectedItemsIterator.hasNext() && !itemsIterator.hasNext();
                        }
                    } else {
                        result = false;
                    }
                    boolean bl = result;
                    return bl;
                }
                finally {
                    ResourceUtils.closeQuietlyIfAutoCloseable(itemsIterator);
                }
            }

            public void describeTo(Description description) {
                description.appendText("is equal to ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<Iterator<T>> returnsAllItemsOf(T ... expectedItems) {
        return IteratorMatchers.returnsAllItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<Iterator<T>> returnsAllItemsOf(final @Nonnull Collection<T> expectedItems) {
        return new TypeSafeMatcher<Iterator<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean matchesSafely(Iterator<T> itemsIterator) {
                try {
                    boolean result;
                    if (itemsIterator != null) {
                        result = true;
                        int index = 0;
                        while (itemsIterator.hasNext() && result) {
                            Object item = itemsIterator.next();
                            result = expectedItems.contains(item);
                            ++index;
                        }
                        if (result) {
                            result = index == expectedItems.size();
                        }
                    } else {
                        result = false;
                    }
                    boolean bl = result;
                    return bl;
                }
                finally {
                    ResourceUtils.closeQuietlyIfAutoCloseable(itemsIterator);
                }
            }

            public void describeTo(Description description) {
                description.appendText("is equal to ").appendValue((Object)expectedItems);
            }
        };
    }

    private IteratorMatchers() {
    }
}

