/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class StringMatchers {
    @Nonnull
    public static Matcher<String> startsWith(final @Nonnull String expectedStart) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                return item != null && item.startsWith(expectedStart);
            }

            public void describeTo(Description description) {
                description.appendText("starts with ").appendValue((Object)expectedStart);
            }
        };
    }

    @Nonnull
    public static Matcher<String> endsWith(final @Nonnull String expectedEnd) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                return item != null && item.endsWith(expectedEnd);
            }

            public void describeTo(Description description) {
                description.appendText("starts with ").appendValue((Object)expectedEnd);
            }
        };
    }

    @Nonnull
    public static Matcher<String> asTrimmedContentEqualsTo(final @Nullable String expected) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                boolean result = expected != null ? (item != null ? expected.trim().equals(item.trim()) : false) : item == null;
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("as trimmed content equals to ").appendValue((Object)expected);
            }
        };
    }

    @Nonnull
    public static Matcher<String> contains(final @Nullable String expected) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                boolean result = expected != null ? (item != null ? item.contains(expected) : false) : item == null;
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("contains ").appendValue((Object)expected);
            }
        };
    }

    public static <T> Matcher<T> toStringIs(final @Nonnull String stringValue) {
        return new TypeSafeMatcher<T>(){

            protected final boolean matchesSafely(@Nonnull T item) {
                return stringValue.equals(item.toString());
            }

            public final void describeTo(@Nonnull Description description) {
                description.appendText("returns on toString() ").appendValue((Object)stringValue);
            }

            protected void describeMismatchSafely(@Nullable T item, @Nonnull Description description) {
                description.appendText("was ").appendValue((Object)(item != null ? item.toString() : null));
            }
        };
    }

    private StringMatchers() {
    }
}

