/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ArrayMatchers {
    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> isEqualTo(T ... expectedItems) {
        return ArrayMatchers.isEqualTo(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<T[]> isEqualTo(final @Nonnull Iterable<T> expectedItems) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(T[] items) {
                boolean result;
                if (items != null) {
                    result = true;
                    Iterator expectedItemsIterator = expectedItems.iterator();
                    UnmodifiableIterator itemsIterator = Iterators.forArray((Object[])items);
                    while (expectedItemsIterator.hasNext() && itemsIterator.hasNext() && result) {
                        Object expectedItem = expectedItemsIterator.next();
                        Object item = itemsIterator.next();
                        result = expectedItem != null ? expectedItem.equals(item) : item == null;
                    }
                    if (result) {
                        result = !expectedItemsIterator.hasNext() && !itemsIterator.hasNext();
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is equal to ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsAllItemsOf(T ... expectedItems) {
        return ArrayMatchers.containsAllItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<T[]> containsAllItemsOf(final @Nonnull Collection<T> expectedItems) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(T[] items) {
                boolean result;
                if (items != null) {
                    if (expectedItems.size() == items.length) {
                        Iterator i = expectedItems.iterator();
                        result = true;
                        while (i.hasNext() & result) {
                            Object expectedItem = i.next();
                            result = ArrayUtils.contains((Object[])items, expectedItem);
                        }
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains all items ").appendValue((Object)expectedItems);
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <T> Matcher<T[]> containsItemsOf(T ... expectedItems) {
        return ArrayMatchers.containsItemsOf(expectedItems != null ? Arrays.asList(expectedItems) : Collections.emptyList());
    }

    @Nonnull
    public static <T> Matcher<T[]> containsItemsOf(final @Nonnull Collection<T> expectedItems) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(T[] items) {
                boolean result;
                if (items != null) {
                    Iterator i = expectedItems.iterator();
                    result = true;
                    while (i.hasNext() & result) {
                        Object expectedItem = i.next();
                        result = ArrayUtils.contains((Object[])items, expectedItem);
                    }
                } else {
                    result = false;
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"contains items ").appendValue((Object)expectedItems);
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T[]> hasSize(final @Nonnegative int size) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(@Nullable T[] item) {
                return size == 0 ? item == null || item.length == 0 : item != null && size == item.length;
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)size);
            }

            protected void describeMismatchSafely(@Nullable T[] actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.length : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }
        };
    }

    @Nonnull
    public static <T> Matcher<T[]> hasSameSizeAs(final @Nullable Object what) {
        return new TypeSafeMatcher<T[]>(){

            public boolean matchesSafely(@Nullable T[] item) {
                return this.getSizeOf(what) == 0 ? item == null || item.length == 0 : item != null && this.getSizeOf(what) == item.length;
            }

            public void describeTo(Description description) {
                description.appendText("has size ").appendValue((Object)(what != null ? this.getSizeOf(what) : 0)).appendText(" (Same as: ").appendValue(what).appendText(")");
            }

            protected void describeMismatchSafely(@Nullable T[] actual, @Nonnull Description description) {
                description.appendValue((Object)(actual != null ? actual.length : 0)).appendText(" (Values: ").appendValue(actual).appendText(")");
            }

            private int getSizeOf(@Nullable Object what2) {
                int result;
                if (what2 == null) {
                    result = 0;
                } else if (what2 instanceof Collection) {
                    result = ((Collection)what2).size();
                } else if (what2 instanceof Map) {
                    result = ((Map)what2).size();
                } else if (what2 instanceof Object[]) {
                    result = ((Object[])what2).length;
                } else if (what2 instanceof CharSequence) {
                    result = ((CharSequence)what2).length();
                } else {
                    throw new IllegalArgumentException("Could not get size of " + what2 + ".");
                }
                return result;
            }
        };
    }

    private ArrayMatchers() {
    }
}

